% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BF_users_functions.r
\name{BFpower.cor}
\alias{BFpower.cor}
\title{Sample Size Determination for the Bayesian correlation test}
\usage{
BFpower.cor(
  alternative,
  h0,
  ROPE = NULL,
  threshold,
  true_rate,
  false_rate,
  prior_analysis,
  k,
  alpha,
  beta,
  scale,
  prior_design = NULL,
  alpha_d,
  beta_d,
  location_d,
  k_d,
  scale_d,
  N = NULL,
  type_rate = "positive",
  plot_power = FALSE,
  plot_rel = FALSE
)
}
\arguments{
\item{alternative}{character. The direction of the alternative hypothesis being tested: two-sided (\code{"two.sided"}), right-sided (\code{"greater"}), or left-sided (\code{"less"}).}

\item{h0}{Numeric scalar. Null rho correlation value. Must be between -0.8 and 0.8.}

\item{ROPE}{Optional numeric vector or scalar specifying bounds for an interval null; used if interval Bayes factor is calculated.
\itemize{
\item For \code{alternative = "two.sided"}, must be a numeric vector of length 2 with distinct finite values.
\item For \code{alternative = "greater"}, must be a single numeric scalar > 0.
\item For \code{alternative = "less"}, must be a single numeric scalar < 0.
}}

\item{threshold}{Numeric scalar. Threshold of compelling evidence (numeric scalar > 1).}

\item{true_rate}{Numeric scalar. Targeted true positive rate (if \code{positive = "positive"}) or true negative rate (if \code{positive = "negative"}).}

\item{false_rate}{Numeric scalar. Targeted false positive rate (if \code{positive = "positive"}) or false negative rate (if \code{positive = "negative"}).}

\item{prior_analysis}{character. Analysis prior under the alternative hypothesis:
default beta (\code{"d_beta"}), beta (\code{"beta"}), or normal moment (\code{"Moment"}).}

\item{k}{Numeric scalar. Parameter for the default beta prior (\code{"d_beta"}).}

\item{alpha}{Numeric scalar. Parameter for the beta prior (\code{"beta"}).}

\item{beta}{Numeric scalar. Parameter for the beta prior (\code{"beta"}).}

\item{scale}{Numeric scalar. Scale parameter for the normal moment prior (\code{"Moment"}).}

\item{prior_design}{character. Design prior  under the alternative hypothesis: default beta (\code{"d_beta"}), beta (\code{"beta"}), normal moment (\code{"Moment"}), or point (\code{"Point"}).}

\item{alpha_d}{Numeric scalar. Parameter for the design beta prior (\code{"beta"}).}

\item{beta_d}{Numeric scalar. Parameter for the design beta prior (\code{"beta"}).}

\item{location_d}{Numeric scalar. Location parameter for the design point prior (\code{"Point"}).}

\item{k_d}{Numeric scalar. Parameter for the design default beta prior (\code{"d_beta"}).}

\item{scale_d}{Numeric scalar. Scale parameter for the design normal moment prior (\code{"Moment"}).}

\item{N}{Numeric integer. Sample size. Only required if the goal is not sample size determination, but rather to calculate the probability of obtaining compelling or misleading evidence for a given sample size.}

\item{type_rate}{character. Character indicating which rate to control: \code{"positive"} (true/false positive rates) or \code{"negative"} (true/false negative rates).}

\item{plot_power}{Logical; if TRUE, plots power curves.}

\item{plot_rel}{Logical; if TRUE, plots the relationship between the BF and data.}
}
\value{
A list of class \code{BFpower_r} containing:
\itemize{
\item \code{type}: Test type (always "Correlation").
\item \code{alternative}: the direction of the alternative hypothesis.
\item \code{h0}: the value of correlation under the null hypothesis.
\item \code{ROPE}: Bounds for interval null (if used).
\item \code{analysis_h1}: List with the analysis prior parameters: \code{prior_analysis}, \code{k}, \code{alpha}, \code{beta}, and \code{scale}.
\item \code{design_h1}: List with the design prior parameters: \code{prior_design}, \code{k}, \code{alpha}, \code{beta}, \code{scale}, and \code{location}.
\item \code{results}: Data frame with the probabilities of compelling/misleading evidence, and with the required sample size.
\item \code{threshold}: Threshold of compelling evidence.
\item \code{plot_power}: Logical, whether power curves are plotted.
\item \code{plot_rel}: Logical, whether the relationship between the BF and the correlation is plotted.
}
}
\description{
Perform sample size determination or the probability of obtaining compelling or misleading evidence for a Bayesian correlation test.
Can handle both point-null and interval-null hypothesis, and allows specifying
analysis and design priors.
}
\details{
\strong{1. Sample size determination mode (when \code{N = NULL}):}

If no sample size is provided, the function determines the minimum sample size required to meet the desired requirements. In this mode, the user must supply the following arguments:
\itemize{
\item \code{type_rate} - either \code{"positive"} to control true/false positive rates, or \code{"negative"} to control true/false negative rates.
\item \code{true_rate} - the targeted true positive or true negative rate (between 0.6 and 0.999).
\item \code{false_rate} - the acceptable false positive or false negative rate (between 0.001 and 0.1).
\item \code{threshold} - the Bayes factor threshold for compelling evidence (must be > 1).
}

The function iteratively finds the smallest sample size for which the probability of obtaining compelling evidence meets or exceeds \code{true_rate}, while the probability of misleading evidence does not exceed \code{false_rate}.

\strong{2. Fixed-sample analysis mode (when \code{N} is supplied):}

If a positive numeric sample size \code{N} is provided, the function computes the probabilities of obtaining compelling or misleading evidence for that fixed sample size. In this mode, the arguments \code{type_rate}, \code{true_rate}, and \code{false_rate} are ignored; only the Bayes factor threshold \code{threshold} is used.

\strong{Hypothesis specification:}

The \code{alternative} argument defines the direction of the alternative hypothesis : \code{"two.sided"} for two-sided, \code{"greater"} for right-sided, or \code{"less"} for left-sided tests. The optional \code{ROPE} argument specifies bounds for an interval null hypothesis. If \code{ROPE = NULL}, a point-null test is assumed.

\strong{Analysis Priors:}

The analysis prior specifies the prior distribution of the correlation under the alternative hypothesis. Depending on \code{prior_analysis}, the user must supply:
\itemize{
\item \code{d_beta} (default beta): \code{k} > 0.
\item \code{beta} (stretched beta): \code{alpha} and \code{beta} > 0.
\item \code{Moment} (normal-moment prior): \code{scale} > 0.
}

\strong{Design Priors (optional):}

A design prior can be supplied to reflect uncertainty about the correlation during study planning. If provided, \code{prior_design} must be one of \code{"d_beta"}, \code{"beta"}, \code{"Moment"}, or \code{"Point"}, and the corresponding parameters must be supplied:
\itemize{
\item \code{d_beta}: \code{k_d} > 0.
\item \code{beta}: \code{alpha_d} and \code{beta_d} > 0.
\item \code{Moment}: \code{scale_d} > 0.
\item \code{Point}: \code{location_d} numeric scalar.
}

\strong{interval null Hypothesis:}

If \code{ROPE} is provided, the function evaluates the Bayes factor for an interval null. Otherwise, a point-null hypothesis is assumed.

\strong{Plotting:}

If \code{plot_power = TRUE}, the function plots the probability of compelling evidence as a function of sample size. If \code{plot_rel = TRUE}, the relationship between the BF and correlation is plotted.
}
\examples{
BFpower.cor(
 alternative = "greater",
   h0 = 0,
   threshold = 3,
   true_rate = 0.8,
   false_rate = 0.05,
   prior_analysis = "d_beta",
   k = 1,
   prior_design = "Point",
   location_d = 0.3,
   plot_power = TRUE,
   plot_rel = TRUE
 )

}
