% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_py_deps_conda}
\alias{install_py_deps_conda}
\title{Install Python dependencies for BERTopic (Conda route)}
\usage{
install_py_deps_conda(
  envname = "r-bertopic",
  python_version = "3.10",
  reinstall = FALSE,
  validate = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{envname}{Character. Conda environment name. Default \code{"r-bertopic"}.}

\item{python_version}{Character. Python version to use, e.g. \code{"3.10"}.}

\item{reinstall}{Logical. If \code{TRUE}, delete any existing env and recreate.}

\item{validate}{Logical. If \code{TRUE}, bind and validate imports (will skip
if reticulate is already initialized to another Python).}

\item{verbose}{Logical. Print progress messages.}
}
\value{
Invisibly returns the path to the Python executable inside the env.
}
\description{
Creates (or reuses) a Conda environment with a pinned Python toolchain,
installs the scientific stack + PyTorch (CPU) + sentence-transformers, then
installs \code{bertopic==0.16.0} via pip. Optionally validates imports.
}
\examples{
\dontrun{
install_py_deps_conda(envname = "r-bertopic", python_version = "3.10")
}
}
