% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Subtaxonomy.R
\name{Subtaxonomy}
\alias{Subtaxonomy}
\alias{SubtaxonomySet}
\alias{GetSpeciesIn}
\title{Subtaxonomy under taxonomical category}
\usage{
Subtaxonomy(
  taxon,
  taxonomy = zoologTaxonomy,
  thesaurus = zoologThesaurus$taxon
)

SubtaxonomySet(
  taxon,
  taxonomy = zoologTaxonomy,
  thesaurus = zoologThesaurus$taxon
)

GetSpeciesIn(
  taxon,
  taxonomy = zoologTaxonomy,
  thesaurus = zoologThesaurus$taxon
)
}
\arguments{
\item{taxon}{A name of any of the taxa, at any rank included in the taxonomy
(from species to family in the zoolog taxonomy).}

\item{taxonomy}{A taxonomy from which to extract the subtaxonomy.
By default \code{taxonomy = \link{zoologTaxonomy}}.}

\item{thesaurus}{A thesaurus allowing datasets with different nomenclatures
to be merged. By default \code{thesaurus = \link{zoologThesaurus}$taxon}.}
}
\value{
\code{Subtaxonomy} returns a data.frame with the same structure of the input
taxonomy but with only the species (rows) included in the queried
\code{taxon}, and the taxonomic ranks (columns)
up to its level.

\code{SubtaxonomySet} returns a character vector including a unique copy
(set) of all the taxa, at any taxonomic rank, under the queried
\code{taxon}.
Equivalent to Subtaxonomy but as a set instead of a dataframe.

\code{GetSpeciesIn} returns a character vector including the species included
in the queried \code{taxon}.
}
\description{
Functions to obtain the subtaxonomy or the set of taxa included in a
particular taxonomic group, according to the \code{\link{zoologTaxonomy}}
by default.
}
\examples{
## Get species of genus Sus:
GetSpeciesIn("Sus")

## Get species of family Bovidae:
GetSpeciesIn("Bovidae")

## Get the subtaxonomy of the Tribe Caprini:
Subtaxonomy("Caprini")

## Use SubtaxonomySet to join categories for computing log-ratios.
## For this, we read an example dataset:
dataFile <- system.file("extdata", "dataValenzuelaLamas2008.csv.gz",
                        package="zoolog")
dataExample <- utils::read.csv2(dataFile,
                                na.strings = "",
                                encoding = "UTF-8")
## We illustrate with a subset of cases to make the example run
## sufficiently fast:
dataExample <- dataExample[1:1000, ]
## Compute the log-ratios joining all taxa from tribe \emph{Caprini}
## to use the reference of \emph{Ovis aries}:
categoriesCaprini <- list('Ovis aries' = SubtaxonomySet("Caprini"))
dataExampleWithLogs <- LogRatios(dataExample,
                                 joinCategories = categoriesCaprini)
}
