% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaEvalPopulation.R
\name{xegaRepEvalPopulation}
\alias{xegaRepEvalPopulation}
\title{Evaluates a population of genes in a a problem environment repeatedly.}
\usage{
xegaRepEvalPopulation(pop, lF)
}
\arguments{
\item{pop}{Population of genes.}

\item{lF}{Local function configuration.}
}
\value{
List of
        \itemize{
        \item \code{$pop} gene vector,
        \item \code{$fit} fitness vector, 
        \item \code{$evalFail} number of failed evaluations.
        }
}
\description{
\code{xegaRepEvalPopulation()} evaluates a population
             of genes in a problem environment \code{lF$rep} times.
             The results of repeatedly evaluating a gene are aggregated:
             \itemize{
             \item \code{gene$fit} is the mean fitness, 
             \item \code{gene$var} is the fitness variance, 
             \item \code{gene$std} is the standard deviation of the fitness,
                   and 
             \item \code{gene$obs} is the number of repetitions. 
             }
}
\details{
Parallelization of the evaluation of fitness functions
         is possible by defining \code{lF$lapply}.
}
\examples{
    parm<-function(x){function() {return(x)}}
pop10<-xegaInitPopulation(10, lFxegaGaGene)
lFxegaGaGene[["lapply"]]<-ApplyFactory(method="Sequential") 
lFxegaGaGene[["rep"]]<-parm(3) 
result<-xegaRepEvalPopulation(pop10, lFxegaGaGene)

}
\seealso{
Other Population Layer: 
\code{\link{xegaBestGeneInPopulation}()},
\code{\link{xegaBestInPopulation}()},
\code{\link{xegaEvalPopulation}()},
\code{\link{xegaInitPopulation}()},
\code{\link{xegaLogEvalsPopulation}()},
\code{\link{xegaNextPopulation}()},
\code{\link{xegaObservePopulation}()},
\code{\link{xegaSummaryPopulation}()}
}
\concept{Population Layer}
