% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update_workflow_model}
\alias{update_workflow_model}
\alias{update_workflow_recipe}
\title{Update components of a workflow within a workflow set}
\usage{
update_workflow_model(x, id, spec, formula = NULL)

update_workflow_recipe(x, id, recipe, blueprint = NULL)
}
\arguments{
\item{x}{A workflow set outputted by \code{\link[=workflow_set]{workflow_set()}} or \code{\link[=workflow_map]{workflow_map()}}.}

\item{id}{A single character string from the \code{wflow_id} column indicating
which workflow to update.}

\item{spec}{A parsnip model specification.}

\item{formula}{An optional formula override to specify the terms of the
model. Typically, the terms are extracted from the formula or recipe
preprocessing methods. However, some models (like survival and bayesian
models) use the formula not to preprocess, but to specify the structure
of the model. In those cases, a formula specifying the model structure
must be passed unchanged into the model call itself. This argument is
used for those purposes.}

\item{recipe}{A recipe created using \code{\link[recipes:recipe]{recipes::recipe()}}}

\item{blueprint}{A hardhat blueprint used for fine tuning the preprocessing.

If \code{NULL}, \code{\link[hardhat:default_recipe_blueprint]{hardhat::default_recipe_blueprint()}} is used.

Note that preprocessing done here is separate from preprocessing that
might be done automatically by the underlying model.}
}
\description{
Workflows can take special arguments for the recipe (e.g. a blueprint) or a
model (e.g. a special formula). However, when creating a workflow set, there
is no way to specify these extra components.

\code{update_workflow_model()} and \code{update_workflow_recipe()} allow users to set
these values \emph{after} the workflow set is initially created. They are
analogous to \code{\link[workflows:add_model]{workflows::add_model()}} or \code{\link[workflows:add_recipe]{workflows::add_recipe()}}.
}
\note{
The package supplies two pre-generated workflow sets, \code{two_class_set}
and \code{chi_features_set}, and associated sets of model fits
\code{two_class_res} and \code{chi_features_res}.

The \verb{two_class_*} objects are based on a binary classification problem
using the \code{two_class_dat} data from the modeldata package. The six
models utilize either a bare formula or a basic recipe utilizing
\code{recipes::step_YeoJohnson()} as a preprocessor, and a decision tree,
logistic regression, or MARS model specification. See \code{?two_class_set}
for source code.

The \verb{chi_features_*} objects are based on a regression problem using the
\code{Chicago} data from the modeldata package. Each of the three models
utilize a linear regression model specification, with three different
recipes of varying complexity. The objects are meant to approximate the
sequence of models built in Section 1.3 of Kuhn and Johnson (2019). See
\code{?chi_features_set} for source code.
}
\examples{
library(parsnip)

new_mod <-
  decision_tree() \%>\%
  set_engine("rpart", method = "anova") \%>\%
  set_mode("classification")

new_set <- update_workflow_model(two_class_res, "none_cart", spec = new_mod)

new_set

extract_workflow(new_set, id = "none_cart")
}
