% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_best.R
\name{fit_best.workflow_set}
\alias{fit_best.workflow_set}
\title{Fit a model to the numerically optimal configuration}
\usage{
\method{fit_best}{workflow_set}(x, metric = NULL, ...)
}
\arguments{
\item{x}{A \code{\link[=workflow_set]{workflow_set}} object that has been evaluated
with \code{\link[=workflow_map]{workflow_map()}}. Note that the workflow set must have been fitted with
the \link[=option_add]{control option} \code{save_workflow = TRUE}.}

\item{metric}{A character string giving the metric to rank results by.}

\item{...}{Additional options to pass to
\link[tune:fit_best]{tune::fit_best}.}
}
\description{
\code{fit_best()} takes results from tuning many models and fits the workflow
configuration associated with the best performance to the training set.
}
\details{
This function is a shortcut for the steps needed to fit the
numerically optimal configuration in a fitted workflow set.
The function ranks results, extracts the tuning result pertaining
to the best result, and then again calls \code{fit_best()} (itself a
wrapper) on the tuning result containing the best result.

In pseudocode:

\if{html}{\out{<div class="sourceCode">}}\preformatted{rankings <- rank_results(wf_set, metric, select_best = TRUE)
tune_res <- extract_workflow_set_result(wf_set, rankings$wflow_id[1])
fit_best(tune_res, metric)
}\if{html}{\out{</div>}}
}
\note{
The package supplies two pre-generated workflow sets, \code{two_class_set}
and \code{chi_features_set}, and associated sets of model fits
\code{two_class_res} and \code{chi_features_res}.

The \verb{two_class_*} objects are based on a binary classification problem
using the \code{two_class_dat} data from the modeldata package. The six
models utilize either a bare formula or a basic recipe utilizing
\code{recipes::step_YeoJohnson()} as a preprocessor, and a decision tree,
logistic regression, or MARS model specification. See \code{?two_class_set}
for source code.

The \verb{chi_features_*} objects are based on a regression problem using the
\code{Chicago} data from the modeldata package. Each of the three models
utilize a linear regression model specification, with three different
recipes of varying complexity. The objects are meant to approximate the
sequence of models built in Section 1.3 of Kuhn and Johnson (2019). See
\code{?chi_features_set} for source code.
}
\examples{
\dontshow{if (rlang::is_installed(c("kknn", "modeldata", "recipes", "yardstick", "dials")) && identical(Sys.getenv("NOT_CRAN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(tune)
library(modeldata)
library(rsample)

data(Chicago)
Chicago <- Chicago[1:1195,]

time_val_split <-
   sliding_period(
      Chicago,
      date,
      "month",
      lookback = 38,
      assess_stop = 1
   )

chi_features_set

chi_features_res_new <-
   chi_features_set \%>\%
   # note: must set `save_workflow = TRUE` to use `fit_best()`
   option_add(control = control_grid(save_workflow = TRUE)) \%>\%
   # evaluate with resamples
   workflow_map(resamples = time_val_split, grid = 21, seed = 1, verbose = TRUE)

chi_features_res_new

# sort models by performance metrics
rank_results(chi_features_res_new)

# fit the numerically optimal configuration to the training set
chi_features_wf <- fit_best(chi_features_res_new)

chi_features_wf

# to select optimal value based on a specific metric:
fit_best(chi_features_res_new, metric = "rmse")
\dontshow{\}) # examplesIf}
}
