% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weekToMonth.R
\name{weekToMonth}
\alias{weekToMonth}
\title{Convert weekly data to monthly data}
\usage{
weekToMonth(wkdata, year = NULL, wkIndex = NULL, wkMethod = "ISO",
  datStart = NULL, format = "\%d-\%m-\%Y")
}
\arguments{
\item{wkdata}{a numeric vector for weekly data to be converted.}

\item{year}{a value for the year of the start of the data.}

\item{wkIndex}{a value for the week index of the start of the data if a week-counting
method is used.}

\item{wkMethod}{a character string for the week-counting methods.
Default is "ISO" for ISO-week;
other options are "epiSat", "epiSun" and "epiMon" for epi-week method
defining Saturday, Sunday and Monday as the firstday in a week, respectively.
In addition, users also have the option of specifying the start date of
the data by "startDat" method.}

\item{datStart}{a character string for the start date of the data.
If left blank, the date generated from the week-counting method will be applied.}

\item{format}{a character string specifying the input formate for \code{datStart}.}
}
\value{
a dataframe containing two column vectors: \code{yearMonth} and
  \code{value}.
}
\description{
Converts weekly data to monthly data.
  The start week or date is needed along with the data. The start week can be
  defined by ISO week or epi week.
}
\examples{
weeklyData = c(1:4, 2:5, 3:6, 4:7, 5:8, 6:9, 1:10)
monthlyData = weekToMonth(weeklyData, year = 2008, wkIndex = 30, wkMethod = "epiMon")
monthlyData = weekToMonth(weeklyData, datStart = "21-07-2008", wkMethod = "startDat")
}
\seealso{
dateFromWeek
}
\author{
You Li
}
