% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{time_components}
\alias{time_components}
\title{Extract time components from a model}
\usage{
time_components(object, ...)
}
\arguments{
\item{object}{A vital mable object with a single model column.}

\item{...}{Not currently used.}
}
\value{
tsibble object containing the time components from the model.
}
\description{
For a mable with a single model column, return the model components
that are indexed by time.
}
\examples{
aus_mortality |>
  dplyr::filter(State == "Victoria", Sex == "female") |>
  model(lee_carter = LC(log(Mortality))) |>
  time_components()

}
