% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_complement.r
\name{bed_complement}
\alias{bed_complement}
\title{Identify intervals in a genome not covered by a query.}
\usage{
bed_complement(x, genome)
}
\arguments{
\item{x}{\code{\link[=tbl_interval]{tbl_interval()}}}

\item{genome}{\code{\link[=tbl_genome]{tbl_genome()}}}
}
\value{
\code{\link[=tbl_interval]{tbl_interval()}}
}
\description{
Identify intervals in a genome not covered by a query.
}
\examples{
x <- trbl_interval(
  ~chrom, ~start, ~end,
  'chr1',      1,      10,
  'chr1',      75,    100
)

genome <- trbl_genome(
  ~chrom, ~size,
  'chr1', 200
)

bed_glyph(bed_complement(x, genome))

genome <- trbl_genome(
   ~chrom,  ~size,
   "chr1", 500,
   "chr2", 600,
   "chr3", 800
)

x <- trbl_interval(
   ~chrom, ~start, ~end,
   "chr1", 100,    300,
   "chr1", 200,    400,
   "chr2", 1,      100,
   "chr2", 200,    400,
   "chr3", 500,    600
)

# intervals not covered by x
bed_complement(x, genome)

}
\seealso{
Other single set operations: \code{\link{bed_cluster}},
  \code{\link{bed_flank}}, \code{\link{bed_merge}},
  \code{\link{bed_shift}}, \code{\link{bed_slop}}
}
