% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genutils.r
\name{validUDinput}
\alias{validUDinput}
\alias{checkTarget}
\alias{checkCDF}
\alias{checkNatural}
\alias{checkDose}
\alias{checkResponse}
\title{Data Validation Utilities for \code{upndown}}
\usage{
validUDinput(cdf, target)

checkTarget(target, tname = "Target")

checkCDF(cdf)

checkNatural(k, parname, toolarge = 1000)

checkDose(x, maxfrac = 0.5)

checkResponse(y)
}
\arguments{
\item{cdf}{vector of values, should be nondecreasing between 0 and 1 (inclusive)}

\item{target}{numeric value(s), should be between 0 and 1 (exclusive)}

\item{k}{(\code{checkNatural()} only) input number to check whether it's a natural number}

\item{parname, tname}{string, name of variable to plug in for reporting the error back}

\item{toolarge}{(\code{checkNatural()} only) what number would be considered too large to be realistic?}

\item{x}{(\code{checkDose()} only) input object to be verified as valid dose values}

\item{maxfrac}{(\code{checkDose()} only) maximum number of unique values (as fraction of sample size) considered realistic for up-and-down data. Default one-half.}

\item{y}{(\code{checkResponse()} only) input object to be verified as valid response values (`TRUE/FALSE or 0/1)}
}
\value{
If a validation issue is found, these functions stop with a relevant error message. If no issue is found, they run through without returning a value.
}
\description{
Validation of input values
}
