% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals.unitquantreg}
\alias{residuals.unitquantreg}
\title{Residuals method for \code{unitquantreg} objects}
\usage{
\method{residuals}{unitquantreg}(object, type = c("quantile", "cox-snell", "working", "partial"), ...)
}
\arguments{
\item{object}{fitted model object of class \code{\link[unitquantreg]{unitquantreg}}.}

\item{type}{character indicating type of residuals. The options are
\code{"quantile"}, \code{"cox-snell"}, \code{"working"} and \code{"partial"}.}

\item{...}{currently not used.}
}
\value{
Numeric vector of residuals extract from an object of class
\code{\link[unitquantreg]{unitquantreg}}.
}
\description{
Extract various types of residuals from unit quantile regression models.
}
\details{
The \code{\link[stats]{residuals}} method can compute quantile
and Cox-Snell residuals. These residuals are defined, respectively, by

\deqn{r_{Q} = \Phi^{-1}\left[ F(y_i \mid \widehat{\mu}_i, \widehat{\theta}_i)\right]}

and

\deqn{r_{CS} = -\log\left[1- F(y_i \mid \widehat{\mu}_i, \widehat{\theta}_i)\right]}
where \eqn{\widehat{\mu}_i} and \eqn{\widehat{\theta}_i} are the fitted values
of parameters \eqn{\mu} and \eqn{\theta}, \eqn{F(\cdot \mid \cdot, \cdot)} is
the cumulative distribution function (c.d.f.) and \eqn{\Phi(\cdot)} is the
c.d.f. of standard Normal distribution.

Apart from the variability due the estimates of parameters,if the fitted
regression model is correctly specified then the quantile
residuals, \eqn{r_Q}, follow a standard Normal distribution and
the Cox-Snell residuals, \eqn{r_{CS}}, follow a standard exponential
distribution.
}
\references{
Cox, D. R. and Snell E. J., (1968). A general definition of residuals. \emph{Journal of the Royal Statistical Society - Series B}, \bold{30}(2), 248--265.

Dunn, P. K. and Smyth, G. K., (1996). Randomized quantile residuals. \emph{Journal of Computational and Graphical Statistics}, \bold{5}(3), 236--244.
}
\author{
André F. B. Menezes
}
