% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CIM.R
\name{CIM}
\alias{CIM}
\title{Conceptual Independence Matrix}
\usage{
CIM(data, scales, outputFile = NULL, outputWidth = 100,
  outputHeight = 100, outputUnits = "cm", faMethod = "minres",
  n.iter = 100, skipRegex = NULL)
}
\arguments{
\item{data}{The dataframe containing the variables.}

\item{scales}{The scales: a names list of character vectors,
where the character vectors specify the variable names, and the
names of each character vector specifies the relevant scale.}

\item{outputFile}{The file to write the output to.}

\item{outputWidth, outputHeight, outputUnits}{The width, height,
and units for the output file.}

\item{faMethod}{The method to pass on to \code{\link[psych:fa]{psych::fa()}}.}

\item{n.iter}{The number of iterations to pass on to \code{\link[psych:fa]{psych::fa()}}.}

\item{skipRegex}{A character vector of length 2 containing two
regular expressions; if the two scales both match one or both
of those regular expressions, that cell is skipped.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} plot.
}
\description{
Conceptual Independence Matrix
}
\examples{
### Load data from psych package
data(bfi,package= 'psych');

### Specify scales
bfiScales <-
  list(Agree = paste0("A", 1:5),
       Consc = paste0("C", 1:5),
       Extra = paste0("E", 1:5),
       Neuro = paste0("N", 1:5),
       Openn = paste0("O", 1:5));

### Only select first two and the first three items to
### keep it quick; just pass the full 'bfiScales'
### object to run for all five the full scales
CIM(bfi,
    scales=lapply(bfiScales, head, 3)[1:2],
    n.iter=10);

}
