% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_submissions.R
\name{process_submissions}
\alias{process_submissions}
\title{Process Submissions}
\usage{
process_submissions(
  path,
  pattern = ".",
  return_value = "Summary",
  key_vars = NULL,
  verbose = 0,
  keep_file_name = NULL
)
}
\arguments{
\item{path}{The path to the directory containing the HTML/XML files.}

\item{pattern}{The pattern to match against the file names (default: ".").}

\item{return_value}{The type of value to return. Allowed values are "Summary" (default) or "All".}

\item{key_vars}{A character vector of key variables to extract from the "id" column (default: NULL).}

\item{verbose}{An integer specifying the verbosity level. 0: no messages, 1: file count messages, 2: some detailed messages about files, 3: detailed messages including all file problems (default: 0).}

\item{keep_file_name}{Specifies whether to keep the file name in the summary tibble. Allowed values are NULL (default), "All" (keep entire file name), "Space" (keep up to first space), or "Underscore" (keep up to first underscore). Only used when \code{return_value} is "Summary".}
}
\value{
If \code{return_value} is "Summary", returns a tibble with one row for each file, columns corresponding to the \code{key_vars},
and an additional "answers" column indicating the number of rows in each tibble.
If \code{return_value} is "All", returns a tibble with all the data combined from all the files.
}
\description{
This function processes submissions from a directory containing HTML/XML files.
It extracts tables from the files, filters them based on a pattern and key variables,
and returns either a summary tibble or a combined tibble with all the data.
}
\examples{
\dontrun{
# Process submissions with default settings
process_submissions("path/to/directory")

# Process submissions with a specific pattern and key variables
process_submissions("path/to/directory", pattern = "^submission", key_vars = c("name", "email"))

# Process submissions and return all data
process_submissions("path/to/directory", return_value = "All")

# Process submissions with verbose output (level 3)
process_submissions("path/to/directory", verbose = 3)

# Process submissions and keep the entire file name in the summary tibble
process_submissions("path/to/directory", return_value = "Summary", keep_file_name = "All")
}
}
