% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findmu.R
\name{findmu}
\alias{findmu}
\title{Determine equidistant means of trinormal ROC data simulation}
\usage{
findmu(mux = 0, sdx = 1, sdy = 1, sdz = 1, VUS = 1/6,
  step = 0.001)
}
\arguments{
\item{mux}{The numeric mean of the healthy class. Default is zero.}

\item{sdx, sdy, sdz}{The numeric standard errors of the healthy, intermediate
and diseased class, for which the according means have to be determined
given a specifiv VUS.}

\item{VUS}{The Volume Under the Surface. A numeric value between 1/6 and 1. Default
is 1/6.}

\item{step}{A numeric indicating the step size each iteration takes in order to
find the closest set of means. Default set to 0.001.}
}
\value{
A data frame with the following components:
  \item{mux}{The initial mean of the healthy class}
  \item{muy}{The mean of the intermediate class computed for the specified \code{VUS}.}
  \item{muz}{The mean of the diseased class computed for the specified \code{VUS}.}
  \item{VUS}{The VUS computed for \code{mux}, \code{muy} and \code{muz}.}
}
\description{
A function that computes the equidistant means \code{muy} and \code{muz} for
a specific \code{mux}. The VUS as well as the set of standard errors are
given as arguments to the function.
}
\details{
Defaults are: VUS = 1/6, standard errors for all three classes equal
  1. The searching algorithm is stepwise increasing the differences
  \code{muy-mux} and \code{muz-mux} according to the variable \code{step}.
  The algorithm stops when the computed VUS exceeds the preferred VUS. The
  according parameters \code{mux, muy, muz} are returned with the computed
  VUS.

  Remark: The bigger \code{VUS} and the smaller \code{step} is chosen, the
  longer the computation lasts.
}
\examples{
# find equidistant means with mux=2.7 and VUS = 0.45:
findmu(mux = 2.7, VUS = 0.45)
# specify standard errors:
findmu(mux = 2.7, sdx = 1.1, sdy = 1.3, sdz = 1.5, VUS = 0.45)
}
