% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openai.R
\name{chatgpt}
\alias{chatgpt}
\title{ChatGPT Wrapper (Deprecated)}
\usage{
chatgpt(
  .llm,
  .model = "gpt-4o",
  .max_tokens = 1024,
  .temperature = NULL,
  .top_p = NULL,
  .top_k = NULL,
  .frequency_penalty = NULL,
  .presence_penalty = NULL,
  .api_url = "https://api.openai.com/",
  .timeout = 60,
  .verbose = FALSE,
  .json = FALSE,
  .stream = FALSE,
  .dry_run = FALSE
)
}
\arguments{
\item{.llm}{An \code{LLMMessage} (passed directly to the \code{openai()} function)}

\item{.model}{A character string specifying the model to use.}

\item{.max_tokens}{An integer specifying the maximum number of tokens  (mapped to \code{.max_completion_tokens} in \code{openai()})}

\item{.temperature}{A numeric value for controlling randomness. This is}

\item{.top_p}{A numeric value for nucleus sampling, indicating the top}

\item{.top_k}{Currently unused, as it is not supported by \code{openai()}.}

\item{.frequency_penalty}{A numeric value that penalizes new tokens based on
their frequency so far.}

\item{.presence_penalty}{A numeric value that penalizes new tokens based on
whether they appear in the text so far.}

\item{.api_url}{Character string specifying the API URL. Defaults to the
OpenAI API endpoint.}

\item{.timeout}{An integer specifying the request timeout in seconds. This is}

\item{.verbose}{Will print additional information about the request (default: false)}

\item{.json}{Should json-mode be used? (detault: false)}

\item{.stream}{Should the response  be processed as a stream (default: false)}

\item{.dry_run}{Should the request is constructed but not actually sent. Useful for debugging and testing. (default: false)}
}
\value{
An \code{LLMMessage} object with the assistant's reply.
}
\description{
Provides a wrapper for the \code{openai()} function to facilitate
migration from the deprecated \code{chatgpt()} function. This ensures backward
compatibility while allowing users to transition to the updated features.
}
\details{
This function is deprecated and is now a wrapper around \code{openai()}. It is
recommended to switch to using \code{openai()} directly in future code. The
\code{chatgpt()} function remains available to ensure backward compatibility for
existing projects.
}
\examples{
\dontrun{
# Using the deprecated chatgpt() function
result <- chatgpt(.llm = llm_message(), .prompt = "Hello, how are you?")
}

}
\seealso{
Use \code{\link[=openai]{openai()}} instead.
}
