% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify.R
\name{classify}
\alias{classify}
\title{Classification on tidy data}
\arguments{
\item{.data}{a data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr). The data frame can be grouped.}

\item{formula}{an object of class "formula": a symbolic description of the model to be fitted.}

\item{...}{name-function pairs of models to be estimated. See 'Details'.}

\item{.cv}{type of 'rsample' cross validation procedure to use to determine optimal hyperparameter values. Default is \code{.cv = "none"}. See 'Details'.}

\item{.cv_args}{additional settings to pass to the 'rsample' cross validation function.}

\item{.weights}{optional name of column containing sample weights.}

\item{.mask}{optional vector of columns names to ignore. Can be useful when using 'y ~ .' formula syntax.}

\item{.return_slices}{logical. Should the output of individual cross validation slices be returned or only the final fit. Default is \code{.return_slices=FALSE}.}

\item{.tune_each_group}{logical. Should optimal hyperparameters be selected for each group or once across all groups. Default is \code{.tune_each_group=TRUE}.}

\item{.force_cv}{logical. Should models be evaluated across all cross validation slices, even if no hyperparameters are tuned. Default is \code{.force_cv=TRUE}.}
}
\value{
A \code{tidyfit.models} frame containing model details for each group.

The \strong{'tidyfit.models' frame} consists of 4 different components:
\enumerate{
\item A group of identifying columns (e.g. model name, data groups, grid IDs)
\item A 'model_object' column, which contains the fitted model.
\item A nested 'settings' column containing model arguments and hyperparameters
\item Columns showing errors, warnings and messages (if applicable)
}

Coefficients, predictions, fitted values or residuals can be accessed using the built-in \code{coef}, \code{predict}, \code{fitted} and \code{resid} methods. Note that all coefficients are transformed to ensure comparability across methods.
}
\description{
This function is a wrapper to fit many different types of linear
classification models on a (grouped) \code{tibble}.
}
\details{
\code{classify} fits all models passed in \code{...} using the \code{\link{m}} function. The models can be passed as name-function pairs (e.g. \code{ols = m("lm")}) or without including a name.

Hyperparameters are tuned automatically using the '.cv' and '.cv_args' arguments, or can be passed to \code{m()} (e.g. \code{lasso = m("lasso", lambda = 0.5)}). See the individual model functions (\code{?m()}) for an overview of hyperparameters.

Cross validation is performed using the 'rsample' package with possible methods including
\itemize{
\item 'initial_split' (simple train-test split)
\item 'initial_time_split' (train-test split with retained order)
\item 'vfold' (aka kfold cross validation)
\item 'loo' (leave-one-out)
\item 'rolling_origin' (generalized time series cross validation, e.g. rolling or expanding windows)
\item 'sliding_window', 'sliding_index', 'sliding_period' (specialized time series splits)
\item 'bootstraps'
}

The negative log loss is used to validate performance in the cross validation.

Note that arguments for weights are automatically passed to the functions by setting the '.weights' argument. Weights are also considered during cross validation by calculating weighted versions of the cross validation loss function.

\code{classify} can handle both binomial and multinomial response distributions, however not all underlying methods are capable of handling a multinomial response.
}
\examples{
data <- tidyfit::Factor_Industry_Returns
data <- dplyr::mutate(data, Return = ifelse(Return > 0, 1, 0))
fit <- classify(data, Return ~ ., m("lasso", lambda = c(0.001, 0.1)), .mask = c("Date", "Industry"))

# Print the models frame
tidyr::unnest(fit, settings)

# View coefficients
coef(fit)

}
\seealso{
\code{\link{regress}}, \code{\link{coef.tidyfit.models}} and \code{\link{predict.tidyfit.models}} method
}
\author{
Johann Pfitzinger
}
