% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data_stocks.R
\name{download_data_stocks}
\alias{download_data_stocks}
\title{Download Stock Data}
\usage{
download_data_stocks(type, start_date, end_date, symbols)
}
\arguments{
\item{type}{A character string representing the data source type. Currently supported type is "stocks_yf" for Yahoo Finance. Defaults to "stocks_yf".}

\item{start_date}{Optional. A character string or Date object in "YYYY-MM-DD" format
specifying the start date for the data. If not provided, a subset of the dataset is returned.}

\item{end_date}{Optional. A character string or Date object in "YYYY-MM-DD" format
specifying the end date for the data. If not provided, a subset of the dataset is returned.}

\item{symbols}{A character vector of stock symbols to download data for. At least one
symbol must be provided.}
}
\value{
A tibble containing the downloaded stock data with columns depending on the data source.
}
\description{
Downloads historical stock data for a given symbol and date range from specified sources.
}
\examples{
\dontrun{
download_data_stocks(type = "stocks_yf", symbols = c("AAPL", "MSFT"))
}
}
