% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tibble-package.R
\docType{package}
\name{tibble-package}
\alias{tibble-package}
\title{tibble: Simple Data Frames}
\description{
Provides a 'tbl_df' class (the 'tibble') that provides
stricter checking and better formatting than the traditional data frame.
}
\details{
The S3 class \code{tbl_df} wraps a local data frame. The main
advantage to using a \code{tbl_df} over a regular data frame is the printing:
tbl objects only print a few rows and all the columns that fit on one screen,
describing the rest of it as text.
}
\section{Methods}{


\code{tbl_df} implements four important base methods:

\describe{
\item{print}{By default only prints the first 10 rows (at most 20), and the
columns that fit on screen; see \code{\link[=print.tbl]{print.tbl()}}}
\item{\code{[}}{Does not simplify (drop) by default, returns a data frame}
\item{\code{[[}, \code{$}}{Calls \code{\link[=.subset2]{.subset2()}} directly,
so is considerably faster. Returns \code{NULL} if column does not exist,
\code{$} warns.}
}
}

\section{Important functions}{

\code{\link[=tibble]{tibble()}} and \code{\link[=tribble]{tribble()}} for construction,
\code{\link[=as_tibble]{as_tibble()}} for coercion,
and \code{\link[=print.tbl]{print.tbl()}} and \code{\link[=glimpse]{glimpse()}} for display.
}

\examples{
tibble(a = 1:26, b = letters)
as_tibble(iris)
}
\seealso{
Useful links:
\itemize{
  \item \url{http://tibble.tidyverse.org/}
  \item \url{https://github.com/tidyverse/tibble}
  \item Report bugs at \url{https://github.com/tidyverse/tibble/issues}
}

}
\author{
\strong{Maintainer}: Kirill Müller \email{krlmlr+r@mailbox.org}

Authors:
\itemize{
  \item Hadley Wickham \email{hadley@rstudio.com}
}

Other contributors:
\itemize{
  \item Romain Francois \email{romain@r-enthusiasts.com} [contributor]
  \item RStudio [copyright holder]
}

}
