% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{add_column}
\alias{add_column}
\title{Add columns to a data frame}
\usage{
add_column(.data, ..., .before = NULL, .after = NULL)
}
\arguments{
\item{.data}{Data frame to append to.}

\item{...}{Name-value pairs, passed on to \code{\link[=tibble]{tibble()}}. All values must have
one element for each row in the data frame, or be of length 1.
These arguments are passed on to \code{\link[=tibble]{tibble()}}, and therefore also support
unquote via \code{!!} and unquote-splice via \code{!!!}.}

\item{.before, .after}{One-based column index or column name where to add the
new columns, default: after last column.}
}
\description{
This is a convenient way to add one or more columns to an existing data
frame.
}
\examples{
# add_column ---------------------------------
df <- tibble(x = 1:3, y = 3:1)

add_column(df, z = -1:1, w = 0)

# You can't overwrite existing columns
\dontrun{
add_column(df, x = 4:6)
}
# You can't create new observations
\dontrun{
add_column(df, z = 1:5)
}
}
\seealso{
Other addition: \code{\link{add_row}}
}
