% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replymarkup.R
\name{InlineKeyboardButton}
\alias{InlineKeyboardButton}
\alias{is.InlineKeyboardButton}
\title{Create an inline keyboard button}
\usage{
InlineKeyboardButton(
  text,
  url = NULL,
  callback_data = NULL,
  switch_inline_query = NULL,
  switch_inline_query_current_chat = NULL
)

is.InlineKeyboardButton(x)
}
\arguments{
\item{text}{Label text on the button.}

\item{url}{(Optional). HTTP url to be opened when button is pressed.}

\item{callback_data}{(Optional). Data to be sent in a
\href{https://core.telegram.org/bots/api#callbackquery}{callback query}
to the bot when button is pressed, 1-64 bytes.}

\item{switch_inline_query}{(Optional). If set, pressing the button will
prompt the user to select one of their chats, open that chat and insert
the bot's username and the specified inline query in the input field.
Can be empty, in which case just the bot's username will be inserted.}

\item{switch_inline_query_current_chat}{(Optional). If set, pressing the
button will insert the bot's username and the specified inline query in
the current chat's input field. Can be empty, in which case only the
bot's username will be inserted.}

\item{x}{Object to be tested.}
}
\description{
This object represents one button of an inline keyboard. You
\strong{must} use exactly one of the optional fields. If all optional fields
are NULL, by defect it will generate \code{callback_data} with same data as
in \code{text}.
}
\details{
\strong{Note:} After the user presses a callback button,
Telegram clients will display a progress bar until you call
\code{\link{answerCallbackQuery}}. It is, therefore, necessary to
react by calling \code{\link{answerCallbackQuery}} even if no notification
to the user is needed (e.g., without specifying any of the
optional parameters).
}
