% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDM3df.R
\name{LDM3df}
\alias{LDM3df}
\title{Landmark estimator for three gap times distribution function.}
\usage{
LDM3df(object, x, y, z)
}
\arguments{
\item{object}{An object of class multidf.}

\item{x}{The first time for obtaining estimates for the trivariate 
distribution function.}

\item{y}{The second time for obtaining estimates for the trivariate 
distribution function.}

\item{z}{The third time for obtaining estimates for the trivariate 
distribution function.}
}
\value{
Vector with the Landmark estimates for three gap times distribution 
function.
}
\description{
Provides estimates for three gap times distribution function 
based on landmarking. The extension of the landmark estimator (LDM) to three 
gap times is a consequence of Bayes' theorem.
}
\examples{
data("bladder5state")
b4state<-multidf(gap1=bladder5state$y1, event1=bladder4state$d1, 
                 gap2=bladder5state$y2, event2=bladder4state$d2,
                 gap3=bladder5state$y3, status=bladder4state$d3)
                 
head(b4state)[[1]]

LDM3df(b4state, x=13, y=20, z=40)

b4<-multidf(gap1=bladder4$t1, event1=bladder4$d1, 
            gap2=bladder4$t2-bladder4$t1, event2=bladder4$d2,
            gap3=bladder4$t3-bladder4$t2, status=bladder4state$d3)

LDM3df(b4,x=13,y=20,z=40)

}
\references{
van Houwelingen, H.C. (2007). Dynamic prediction by landmarking 
in event history analysis, Scandinavian Journal of Statistics, 34, 70-85.

Kaplan, E. and Meier, P. (1958). Nonparametric Estimation from Incomplete 
Observations, Journal of the American Statistical Association 53(282), 
457-481.
}
\seealso{
\code{\link{LDM3df}}, \code{\link{LIN3df}} and \code{\link{WCH3df}}.
}
\author{
Gustavo Soutinho and Luis Meira-Machado
}
