% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strataG-internal.R
\name{strataG-internal}
\alias{strataG-internal}
\alias{.getFileLabel}
\alias{.parseLocusNames}
\alias{.setupClusters}
\alias{.strataPairs}
\alias{.removeIdsMissingAllLoci}
\alias{.applyPerLocus}
\alias{.numericLoci}
\title{Internal Functions}
\usage{
.getFileLabel(g, label = NULL)

.parseLocusNames(locus.names, ploidy)

.setupClusters(num.cores = NULL)

.strataPairs(g)

.removeIdsMissingAllLoci(g)

.applyPerLocus(fun, g, ...)

.numericLoci(g, min.val = 0)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{label}{label for filename(s). Default is the gtypes description if present.}

\item{locus.names}{a vector of column names, where each locus must be
named with the same roots. For example, diploid locus 'ABCD' would have
two columns named something like 'ABCD.1' and 'ABCD.2', or
'ABCD_A' and 'ABCD_B'.\cr}

\item{ploidy}{integer representing the ploidy of the data.}

\item{num.cores}{number of cores for multithreading. If \code{NULL}, the number 
used is set to the value of \code{detectCores() - 1}.}

\item{fun}{a function that takes one locus column at a time.}

\item{g}{a \linkS4class{gtypes} object.}

\item{g}{a \linkS4class{gtypes} object.}

\item{g}{a \linkS4class{gtypes} object.}

\item{g}{a \linkS4class{gtypes} object.}
}
\description{
Functions intended to be used only by functions within 
  the strataG package.
}
\details{
\describe{
  \item{.getFileLabel}{}
  \item{.parseLocusNames}{}
  \item{.setupClusters}{}
  \item{.strataPairs}{}
}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\keyword{internal}
