% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_models.R
\name{evaluate_models}
\alias{evaluate_models}
\title{Creates and evaluates multiple varying coefficient GAM GP smooth models (SVC or STVC)}
\usage{
evaluate_models(
  input_data,
  target_var = "privC",
  covariates = c("unemp", "pubC"),
  coords_x = "X",
  coords_y = "Y",
  STVC = FALSE,
  time_var = NULL,
  ncores = 2
)
}
\arguments{
\item{input_data}{a \code{data.frame}, \code{tibble} \code{sf} containing the target variables, covariates and coordinate variables}

\item{target_var}{the name of the target variable in \code{data}}

\item{covariates}{the name of the covariates (predictor variables) in \code{data}}

\item{coords_x}{the name of the X, Easting or Longitude variable in \code{data}}

\item{coords_y}{the name of the Y, Northing or Latitude variable in \code{data}}

\item{STVC}{a logical operator to indicate whether the models Space-Time (\code{TRUE}) or just Space (\code{FALSE})}

\item{time_var}{the name of the time variable if undertaking STVC model evaluations}

\item{ncores}{the number of cores to use in parallelised approaches (default is 2 to overcome CRAN package checks). This can be determined for your computer by running \code{parallel::detectCores()-1}. Parallel approaches are only undertaken if the number of models to evaluate is greater than 30.}
}
\value{
A data table in \code{data.frame} format of all possible model combinations with each covariate specified in all possible ways, with the BIC of the model and the model formula.
}
\description{
Creates and evaluates multiple varying coefficient GAM GP smooth models (SVC or STVC)
}
\examples{
library(dplyr)
library(glue)
library(purrr)
library(doParallel)
library(mgcv)
data("productivity")
input_data = productivity |> filter(year == "1970")
svc_res_gam =
  evaluate_models(input_data = input_data,
                  target_var = "privC",
                  covariates = c("unemp", "pubC"),
                  coords_x = "X",
                  coords_y = "Y",
                  STVC = FALSE)
head(svc_res_gam)
}
