% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correction_functions.R
\name{eem_setNA}
\alias{eem_setNA}
\title{set parts of specific samples to NA and optionally interpolate these parts}
\usage{
eem_setNA(
  eem_list,
  sample = NULL,
  em = NULL,
  ex = NULL,
  interpolate = TRUE,
  ...
)
}
\arguments{
\item{eem_list}{EEMs as eemlist}

\item{sample}{optional, names or indices of samples to process}

\item{em}{optional, emission wavelengths to set NA}

\item{ex}{optional, excitation wavelengths to set NA}

\item{interpolate}{FALSE, 1 or 2, interpolate NAs or not, 2 different methods, see \code{\link[staRdom]{eem_interp}}}

\item{...}{arguments passed on to \code{\link[staRdom]{eem_interp}}}
}
\value{
eemlist
}
\description{
set parts of specific samples to NA and optionally interpolate these parts
}
\details{
Samples and wavelengths are optional and if not set all of them are considered in setting data to NA. Wavelengths can be set as vectors containing more than the wavelengths present in the data. E.g. 230:250 removes all wavelengths between 230 and 250 if present. Data is best interpolated if it does not reach data boundaries. Please check the results otherwise as in some cases the interpolation might not produce meaningful data.
}
\examples{
data(eem_list)
eem <- eem_list[1:9]
class(eem) <- "eemlist"

ggeem(eem)

eem_list2 <- eem_setNA(eem,ex=200:280,em=500:600, interpolate=FALSE)
ggeem(eem_list2)
}
