% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplex.R
\name{simplex}
\alias{simplex}
\alias{simplex,sf-method}
\alias{simplex,SpatRaster-method}
\title{simplex forecast}
\usage{
\S4method{simplex}{sf}(
  data,
  target,
  lib = NULL,
  pred = NULL,
  E = 1:10,
  tau = 1,
  k = E + 2,
  nb = NULL,
  threads = detectThreads(),
  trend.rm = TRUE
)

\S4method{simplex}{SpatRaster}(
  data,
  target,
  lib = NULL,
  pred = NULL,
  E = 1:10,
  tau = 1,
  k = E + 2,
  threads = detectThreads(),
  trend.rm = TRUE
)
}
\arguments{
\item{data}{The observation data.}

\item{target}{Name of target variable.}

\item{lib}{(optional) Libraries indices.}

\item{pred}{(optional) Predictions indices.}

\item{E}{(optional) Dimensions of the embedding.}

\item{tau}{(optional) Step of spatial lags.}

\item{k}{(optional) Number of nearest neighbors used in prediction.}

\item{nb}{(optional) The neighbours list.}

\item{threads}{(optional) Number of threads.}

\item{trend.rm}{(optional) Whether to remove the linear trend.}
}
\value{
A list
\describe{
\item{\code{xmap}}{self mapping prediction results}
\item{\code{varname}}{name of target variable}
}
}
\description{
simplex forecast
}
\examples{
columbus = sf::read_sf(system.file("case/columbus.gpkg", package="spEDM"))
\donttest{
simplex(columbus,"crime")
}
}
\references{
Sugihara G. and May R. 1990. Nonlinear forecasting as a way of distinguishing chaos from measurement error in time series. Nature, 344:734-741.
}
