% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/somspa.R
\name{somspa}
\alias{somspa}
\title{Spatial SOM}
\usage{
somspa(x, ...)
}
\arguments{
\item{x}{A \code{sominp} object.}

\item{...}{Other arguments passed to methods from \code{kohonen::som} function which is used to create the SOM.}
}
\value{
A \code{somsp} object, which contains:

\itemize{

\item{A summary \code{data.table} with the coordinates of each SOM node, the distances of objects
to their corresponding winning unit, the number of points of each node, as well as the median
latitude and longitude of each node coordinates and their standard deviation.}

\item{A Self-Organizing Map object (see also \code{\link{kohonen}}).}

\item{The \code{sominp} object used as input for the SOM, with an id number coressponding to
location and a node number to the classification group of SOM.}
}
}
\description{
\code{somspa} creates a Self-Organizing Map from spatial data.
}
\details{
\code{x} should be created by \code{sominp}.
The output \code{somsp} objects can be plotted by \code{plot} and \code{plot_ts} functions or summarized by \code{summary}
}
\examples{
\donttest{
dummy <- owda[Time <= 1600] #toy example
inp_som <- sominp(dummy)

my_som <- somspa(inp_som, rlen = 100, grid = somgrid(3, 3, "hexagonal"))
my_som$summary
my_som$som

plot(my_som)
plot_ts(my_som, n = 3)
plot_ts(my_som, n = c(1, 2, 4, 9)) 
plot_ts(my_som, n = 1:max(my_som$summary$node)) #plots all soms}

}
\seealso{
\code{\link{som}}

\code{\link{sominp}}
}
