% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{aggregate.sf}
\alias{aggregate.sf}
\alias{aggregate}
\title{aggregate an \code{sf} object}
\usage{
\method{aggregate}{sf}(x, by, FUN, ..., do_union = TRUE, simplify = TRUE,
  join = st_intersects)
}
\arguments{
\item{x}{object of class \link{sf}}

\item{by}{either a list of grouping vectors with length equal to \code{nrow(x)} (see \link[stats]{aggregate}), or an object of class \code{sf} or \code{sfc} with geometries that are used to generate groupings, using the binary predicate specified by the argument \code{join}}

\item{FUN}{function passed on to \link[stats]{aggregate}, in case \code{ids} was specified and attributes need to be grouped}

\item{...}{arguments passed on to \code{FUN}}

\item{do_union}{logical; should grouped geometries be unioned using \link{st_union}? See details.}

\item{simplify}{logical; see \link[stats]{aggregate}}

\item{join}{logical spatial predicate function to use if \code{by} is a simple features object or geometry; see \link{st_join}}
}
\value{
an \code{sf} object with aggregated attributes and geometries; additional grouping variables having the names of \code{names(ids)} or are named \code{Group.i} for \code{ids[[i]]}; see \link[stats]{aggregate}.
}
\description{
aggregate an \code{sf} object, possibly union-ing geometries
}
\details{
In case \code{do_union} is \code{FALSE}, \code{aggregate} will simply combine geometries using \link{c.sfg}. When polygons sharing a boundary are combined, this leads to geometries that are invalid; see \url{https://github.com/r-spatial/sf/issues/681}.
}
\note{
Does not work using the formula notation involving \code{~} defined in \link[stats]{aggregate}.
}
\examples{
m1 = cbind(c(0, 0, 1, 0), c(0, 1, 1, 0))
m2 = cbind(c(0, 1, 1, 0), c(0, 0, 1, 0))
pol = st_sfc(st_polygon(list(m1)), st_polygon(list(m2)))
set.seed(1985)
d = data.frame(matrix(runif(15), ncol = 3))
p = st_as_sf(x = d, coords = 1:2)
plot(pol)
plot(p, add = TRUE)
(p_ag1 = aggregate(p, pol, mean))
plot(p_ag1) # geometry same as pol
# works when x overlaps multiple objects in 'by':
p_buff = st_buffer(p, 0.2)
plot(p_buff, add = TRUE)
(p_ag2 = aggregate(p_buff, pol, mean)) # increased mean of second
# with non-matching features
m3 = cbind(c(0, 0, -0.1, 0), c(0, 0.1, 0.1, 0))
pol = st_sfc(st_polygon(list(m3)), st_polygon(list(m1)), st_polygon(list(m2)))
(p_ag3 = aggregate(p, pol, mean))
plot(p_ag3)
# In case we need to pass an argument to the join function:
(p_ag4 = aggregate(p, pol, mean, 
     join = function(x, y) st_is_within_distance(x, y, dist = 0.3)))
}
