% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast_sfc.R
\name{st_is}
\alias{st_is}
\title{test equality between the geometry type and a class or set of classes}
\usage{
st_is(x, type)
}
\arguments{
\item{x}{object of class \code{sf}, \code{sfc} or \code{sfg}}

\item{type}{character; class, or set of classes, to test against}
}
\description{
test equality between the geometry type and a class or set of classes
}
\examples{
st_is(st_point(0:1), "POINT")
sfc = st_sfc(st_point(0:1), st_linestring(matrix(1:6,,2)))
st_is(sfc, "POINT")
st_is(sfc, "POLYGON")
st_is(sfc, "LINESTRING")
st_is(st_sf(a = 1:2, sfc), "LINESTRING")
st_is(sfc, c("POINT", "LINESTRING"))
}
