% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf.R, R/wkb.R, R/wkt.R, R/sp.R, R/maps.R
\name{st_as_sfc}
\alias{st_as_sfc}
\alias{st_as_sfc.list}
\alias{st_as_sfc}
\alias{st_as_sfc.WKB}
\alias{st_as_sfc}
\alias{st_as_sfc.character}
\alias{st_as_sfc}
\alias{st_as_sfc.factor}
\alias{st_as_sfc}
\alias{st_as_sfc}
\alias{st_as_sfc.SpatialPoints}
\alias{st_as_sfc}
\alias{st_as_sfc.SpatialPixels}
\alias{st_as_sfc}
\alias{st_as_sfc.SpatialMultiPoints}
\alias{st_as_sfc}
\alias{st_as_sfc.SpatialLines}
\alias{st_as_sfc}
\alias{st_as_sfc.SpatialPolygons}
\alias{st_as_sfc}
\alias{st_as_sfc.map}
\title{Convert foreign geometry object to an sfc object}
\usage{
\method{st_as_sfc}{list}(x, ..., crs = NA_crs_)

\method{st_as_sfc}{WKB}(x, ..., EWKB = FALSE, spatialite = FALSE,
  pureR = FALSE, crs = NA_crs_)

\method{st_as_sfc}{character}(x, crs = NA_integer_, ...)

\method{st_as_sfc}{factor}(x, ...)

st_as_sfc(x, ...)

\method{st_as_sfc}{SpatialPoints}(x, ...)

\method{st_as_sfc}{SpatialPixels}(x, ...)

\method{st_as_sfc}{SpatialMultiPoints}(x, ...)

\method{st_as_sfc}{SpatialLines}(x, ..., forceMulti = FALSE)

\method{st_as_sfc}{SpatialPolygons}(x, ..., forceMulti = FALSE)

\method{st_as_sfc}{map}(x, ...)
}
\arguments{
\item{x}{object to convert}

\item{...}{further arguments}

\item{crs}{integer or character; coordinate reference system for the geometry, see \link{st_crs}}

\item{EWKB}{logical; if TRUE, parse as EWKB (extended WKB; PostGIS: ST_AsEWKB), otherwise as ISO WKB (PostGIS: ST_AsBinary)}

\item{spatialite}{logical; if \code{TRUE}, assume the WKB is assumed to be in the spatialite dialect, see \url{https://www.gaia-gis.it/gaia-sins/BLOB-Geometry.html}}

\item{pureR}{logical; if TRUE, use only R code, if FALSE, use compiled (C++) code; use TRUE when the endian-ness of the binary differs from the host machine (\code{.Platform$endian}).}

\item{forceMulti}{logical; if \code{TRUE}, force coercion into \code{MULTIPOLYGON} or \code{MULTILINE} objects, else autodetect}
}
\description{
Convert foreign geometry object to an sfc object
}
\details{
when converting from WKB, the object \code{x} is either a character vector such as typically obtained from PostGIS (either with leading "0x" or without), or a list with raw vectors representing the features in binary (raw) form.

if \code{x} is a character vector, it should be a vector containing the well-known-text representations of a single geometry for each vector element

if \code{x} is a \code{factor}, it is converted to \code{character}
}
\examples{
wkb = structure(list("01010000204071000000000000801A064100000000AC5C1441"), class = "WKB")
st_as_sfc(wkb, EWKB = TRUE)
wkb = structure(list("0x01010000204071000000000000801A064100000000AC5C1441"), class = "WKB")
st_as_sfc(wkb, EWKB = TRUE)
}
