% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc.R
\name{sfc}
\alias{sfc}
\alias{st_sfc}
\title{Create simple feature collection object of class sfc from list}
\usage{
st_sfc(..., crs = NA_crs_, precision = 0)
}
\arguments{
\item{...}{one or more simple feature geometries}

\item{crs}{coordinate reference system: integer with the epsg code, or character with proj4string}

\item{precision}{numeric; see \link{st_as_binary}}
}
\description{
Create simple feature list column, set class, and add coordinate reference system
}
\details{
a simple feature collection object is a list of class 
\code{c("stc_TYPE", "sfc")} which contains objects of identical type. This 
function creates such an object from a list of simple feature geometries (of 
class \code{sfg}).
}
\examples{
pt1 = st_point(c(0,1))
pt2 = st_point(c(1,1))
(sfc = st_sfc(pt1, pt2))
d = data.frame(a = 1:2)
}

