% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_se.R
\name{rename_se}
\alias{rename_se}
\title{rename standard interface.}
\usage{
rename_se(.data, mapping, splitTerms = TRUE, env = parent.frame())
}
\arguments{
\item{.data}{data.frame}

\item{mapping}{named character vector of columns to rename (new names on the left, original names on the right; this may seem reversed but it matches dplyr::rename()).}

\item{splitTerms}{logical, if TRUE into separate renames (if FALSE instead, pass all at once to dplyr).}

\item{env}{environment to work in.}
}
\value{
.data with renamed columns
}
\description{
rename columns (much different syntax than \code{\link[dplyr]{rename_at}}).
All left hand sides are new column names and all right hand sides are old column names (
this allows swaps).
}
\examples{


datasets::mtcars \%.>\%
   rename_se(., c("cylinders" := "cyl", "gears" := "gear")) \%.>\%
   head(.)
# # same as:
# datasets::mtcars \%>\%
#    rename(cylinders = cyl, gears = gear) \%>\%
#    head()

# rename_se allows column swaps
data.frame(a = 1, b = 2) \%.>\%
   rename_se(., c('a', 'b') := c('b', 'a'))

}
\seealso{
\code{\link[dplyr]{rename}},  \code{\link[dplyr]{rename_at}}, \code{\link[wrapr]{:=}}
}
