% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-point.R
\name{assert_dims_ok_point}
\alias{assert_dims_ok_point}
\title{Assert Inputs Have Matching Dimensions}
\usage{
assert_dims_ok_point(observed, predicted)
}
\arguments{
\item{observed}{Input to be checked. Should be a factor of length n with
exactly two levels, holding the observed values.
The highest factor level is assumed to be the reference level. This means
that \code{predicted} represents the probability that the observed value is
equal to the highest factor level.}

\item{predicted}{Input to be checked. \code{predicted} should be a vector of
length n, holding probabilities. Alternatively, \code{predicted} can be a matrix
of size n x 1. Values represent the probability that
the corresponding value in \code{observed} will be equal to the highest
available factor level.}
}
\value{
Returns NULL invisibly if the assertion was successful and throws an
error otherwise.
}
\description{
Function assesses whether input dimensions match. In the
following, n is the number of observations / forecasts. Scalar values may
be repeated to match the length of the other input.
Allowed options are therefore:
\itemize{
\item \code{observed} is vector of length 1 or length n
\item \code{predicted} is:
\itemize{
\item a vector of of length 1 or length n
\item a matrix with n rows and 1 column
}
}
}
\keyword{internal_input_check}
