% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_stability.R
\name{run_stability_analysis}
\alias{run_stability_analysis}
\title{Test stability of a decomposition by subsampling or bootstrapping donors. Note that
running this function will replace the decomposition in the project container
with one resulting from the tucker parameters entered here.}
\usage{
run_stability_analysis(
  container,
  ranks,
  tucker_type = "regular",
  rotation_type = "hybrid",
  sparsity = sqrt(2),
  subset_type = "subset",
  sub_prop = 0.75,
  n_iterations = 100,
  ncores = container$experiment_params$ncores
)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{ranks}{numeric The number of donor, gene, and cell type ranks, respectively,
to decompose to using Tucker decomposition.}

\item{tucker_type}{character Set to 'regular' to run regular tucker or to 'sparse' to run tucker
with sparsity constraints (default='regular')}

\item{rotation_type}{character Set to 'hybrid' to optimize loadings via our hybrid
method (see paper for details). Set to 'ica_dsc' to perform ICA rotation
on resulting donor factor matrix. Set to 'ica_lds' to optimize loadings by the
ICA rotation. (default='hybrid')}

\item{sparsity}{numeric To use with sparse tucker. Higher indicates more sparse (default=sqrt(2))}

\item{subset_type}{character Set to either 'subset' or 'bootstrap' (default='subset')}

\item{sub_prop}{numeric The proportion of donors to keep when using subset_type='subset' (default=.75)}

\item{n_iterations}{numeric The number of iterations to perform (default=100)}

\item{ncores}{numeric The number of cores to use (default=container$experiment_params$ncores)}
}
\value{
The project container with the donor scores stability plot in
container$plots$stability_plot_dsc and the loadings stability plot in
container$plots$stability_plot_lds
}
\description{
Test stability of a decomposition by subsampling or bootstrapping donors. Note that
running this function will replace the decomposition in the project container
with one resulting from the tucker parameters entered here.
}
\examples{
test_container <- run_stability_analysis(test_container, ranks=c(2,4),
tucker_type='regular', rotation_type='hybrid', subset_type='subset', 
sub_prop=0.75, n_iterations=5, ncores=1)
}
