#define USE_FC_LEN_T
#define STRICT_R_HEADERS
#include <Rcpp.h>
#include <R.h>
#include <Rinternals.h>
#include <R_ext/Rdynload.h>
#include <Rmath.h>
#include "defines.h"
#include <rxode2parse.h>
#include <R.h>
#ifdef ENABLE_NLS
#include <libintl.h>
#define _(String) dgettext ("rxode2et", String)
/* replace pkg as appropriate */
#else
#define _(String) (String)
#endif

using namespace Rcpp;

#define rxode2random_loaded rxode2et_rxode2random_loaded
#define rxode2random rxode2et_rxode2random
#define loadNamespace rxode2et_loadNamespace

Function loadNamespace("loadNamespace", R_BaseNamespace);
bool rxode2random_loaded = false;
Environment rxode2random;


extern "C" bool _rxode2et_qtest(SEXP in, const char *test) {
  if (!rxode2random_loaded) {
    rxode2random_loaded = true;
    rxode2random = loadNamespace("rxode2random");
  }
  Function fun = as<Function>(rxode2random[".qtest"]);
  CharacterVector c(1);
  c[0]= test;
  return as<bool>(fun(in, c));
}

extern "C" SEXP _rxode2et_qstrictS(SEXP nn, const char *what) {
  if (!rxode2random_loaded) {
    rxode2random_loaded = true;
    rxode2random = loadNamespace("rxode2random");
  }
  Function fun = as<Function>(rxode2random[".qstrictS"]);
  CharacterVector c(1);
  c[0]= what;
  return (fun(nn, c));
}

extern "C" SEXP _rxode2et_qstrictSn(SEXP x_, const char *what) {
  if (!rxode2random_loaded) {
    rxode2random_loaded = true;
    rxode2random = loadNamespace("rxode2random");
  }
  Function fun = as<Function>(rxode2random[".qstrictSn"]);
  CharacterVector c(1);
  c[0]= what;
  return (fun(x_, c));
}

extern "C" SEXP _rxode2et_qstrictSdn(SEXP x_, const char *what) {
  if (!rxode2random_loaded) {
    rxode2random_loaded = true;
    rxode2random = loadNamespace("rxode2random");
  }
  Function fun = as<Function>(rxode2random[".qstrictSdn"]);
  CharacterVector c(1);
  c[0]= what;
  return (fun(x_, c));
}

extern "C" SEXP _rxode2et_qassertS(SEXP in, const char *test, const char *what) {
  if (!rxode2random_loaded) {
    rxode2random_loaded = true;
    rxode2random = loadNamespace("rxode2random");
  }
  Function fun = as<Function>(rxode2random[".qassertS"]);
  CharacterVector c(1);
  c[0]= test;
  CharacterVector c2(1);
  c2[0]= what;
  return (fun(in, c, c2));
}

extern "C" SEXP _rxode2et_convertId_(SEXP id) {
  if (!rxode2random_loaded) {
    rxode2random_loaded = true;
    rxode2random = loadNamespace("rxode2random");
  }
  Function fun = as<Function>(rxode2random[".convertId"]);
  return(fun(id));
}

extern "C" SEXP _rxode2et_expandPars_(SEXP objectSSEXP, SEXP paramsSSEXP, SEXP eventsSSEXP, SEXP controlSSEXP) {
  if (!rxode2random_loaded) {
    rxode2random_loaded = true;
    rxode2random = loadNamespace("rxode2random");
  }
  Function fun = as<Function>(rxode2random[".expandPars"]);
  return fun(objectSSEXP, paramsSSEXP, eventsSSEXP, controlSSEXP);
}
