% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vinecop_plot.R
\name{plot.vinecop_dist}
\alias{plot.vinecop_dist}
\alias{contour.vinecop_dist}
\alias{plot.vinecop}
\alias{contour.vinecop}
\title{Plotting \code{vinecop_dist} and \code{vinecop} objects.}
\usage{
\method{plot}{vinecop_dist}(x, tree = 1, var_names = "ignore", edge_labels = NULL, ...)

\method{plot}{vinecop}(x, tree = 1, var_names = "ignore", edge_labels = NULL, ...)

\method{contour}{vinecop_dist}(x, tree = "ALL", cex.nums = 1, ...)

\method{contour}{vinecop}(x, tree = "ALL", cex.nums = 1, ...)
}
\arguments{
\item{x}{\code{vinecop_dist} object.}

\item{tree}{\code{"ALL"} or integer vector; specifies which trees are
plotted.}

\item{var_names}{integer; specifies how to make use of variable names:
\itemize{
\item `"ignore"`` = variable names are ignored,
\item `"use"`` = variable names are used to annotate vertices,
\item `"legend"`` = uses numbers in plot and adds a legend for variable names,
\item `"hide"`` = no numbers or names, just the node.
}}

\item{edge_labels}{character; options are:
\itemize{
\item \code{"family"} = pair-copula family (see \verb{[bicop_dist()]}),
\item `"tau"`` = pair-copula Kendall's tau
\item `"family_tau"`` = pair-copula family and Kendall's tau,
\item `"pair"`` = the name of the involved variables.
}}

\item{\dots}{Unused for \code{plot} and passed to
\code{\link[rvinecopulib:contour.bicop]{contour.bicop}} for \code{contour}.}

\item{cex.nums}{numeric; expansion factor for font of the numbers.}
}
\description{
There are two plotting generics for \code{vinecop_dist} objects.
\code{plot.vinecop_dist} plots one or all trees of a given R-vine copula
model. Edges can be labeled with information about the corresponding
pair-copula. \code{contour.vinecop_dist} produces a matrix of contour plots
(using \code{\link[rvinecopulib:plot.bicop]{plot.bicop}}).
}
\details{
If you want the contour boxes to be perfect squares, the plot height should
be \code{1.25/length(tree)*(d - min(tree))} times the plot width.
}
\examples{
# set up vine copula model
d <- 20
n <- 2e2
u <- matrix(runif(n * d), n, d)
vc <- vinecop(u, family = "indep")

# plot
plot(vc, tree = c(1, 2))
plot(vc, edge_labels = "pair")

# set up another vine copula model
pcs <- lapply(1:3, function(j) # pair-copulas in tree j
  lapply(runif(4 - j), function(cor) bicop_dist("gaussian", 0, cor)))
mat <- rvine_matrix_sim(4)
vc <- vinecop_dist(pcs, mat)

# contour plot
contour(vc)
}
\seealso{
\code{\link[rvinecopulib:vinecop_dist]{vinecop_dist}},
\code{\link[rvinecopulib:plot.bicop]{plot.bicop}}
}
\author{
Thomas Nagler, Thibault Vatter
}
\keyword{plot}
