% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scto_read.R
\name{scto_read}
\alias{scto_read}
\title{Read data from a SurveyCTO server}
\usage{
scto_read(
  auth,
  ids = NULL,
  start_date = "1900-01-01",
  review_status = "approved",
  private_key = NULL,
  drop_empty_cols = TRUE,
  convert_datetime = c("CompletionDate", "SubmissionDate", "starttime", "endtime"),
  datetime_format = "\%b \%e, \%Y \%I:\%M:\%S \%p",
  simplify = TRUE
)
}
\arguments{
\item{auth}{\code{\link[=scto_auth]{scto_auth()}} object.}

\item{ids}{Character vector indicating IDs of the datasets and/or forms.
\code{NULL} indicates all datasets and forms.}

\item{start_date}{Date-time or something coercible to a date-time
indicating the earliest date-time for which to fetch data. Only used for
forms.}

\item{review_status}{String or character vector indicating which submissions
to fetch. Possible values are "approved", "pending", "rejected", or any
combination of the three. Only used for forms.}

\item{private_key}{String indicating path to private key file. Only needs to
be non-\code{NULL} to read encrypted form data.}

\item{drop_empty_cols}{Logical indicating whether to drop columns that
contain only \code{NA} or only an empty string.}

\item{convert_datetime}{Character vector of column names in the data for
which to convert strings to datetimes (POSIXct). Use \code{NULL} to not convert
any columns to datetimes.}

\item{datetime_format}{String indicating format of datetimes from SurveyCTO.
See \code{\link[=strptime]{strptime()}}.}

\item{simplify}{Logical indicating whether to return only a \code{data.table}
instead of a list of \code{data.table}s if reading one form or dataset.}
}
\value{
If \code{simplify} is \code{TRUE} and reading one form or dataset, a
\code{data.table}. Otherwise a named list of \code{data.table}s, one for each form
and dataset, along with a \code{data.table} named ".catalog" from
\code{scto_catalog()}.
}
\description{
This function can read both datasets and forms.
}
\examples{
\dontrun{
auth = scto_auth('scto_auth.txt')
scto_data = scto_read(auth, 'my_form')
scto_db = scto_read(auth)
}

}
\seealso{
\code{\link[=scto_auth]{scto_auth()}}, \code{\link[=scto_meta]{scto_meta()}}, \code{\link[=scto_get_form_definitions]{scto_get_form_definitions()}},
\code{\link[=scto_get_attachments]{scto_get_attachments()}}, \code{\link[=scto_write]{scto_write()}}
}
