% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_FTRL.R
\docType{data}
\name{FTRL}
\alias{FTRL}
\title{Creates FTRL proximal logistic regression  model.}
\format{\code{R6Class} object.}
\usage{
FTRL
}
\description{
Creates 'Follow the Regularized Leader' model.
Only logistic regression implemented at the moment.
}
\section{Fields}{

\describe{
\item{\code{verbose}}{\code{logical = TRUE} whether to display training inforamtion}
}}

\section{Usage}{

For usage details see \bold{Methods, Arguments and Examples} sections.
\preformatted{
ftrl = FTRL$new(learning_rate = 0.1, learning_rate_decay = 0.5,
lambda = 0, l1_ratio = 1, dropout = 0, family = "binomial")
ftrl$partial_fit(x, y, ...)
ftrl$predict(x, ...)
ftrl$coef()
}
}

\section{Methods}{

\describe{
  \item{\code{FTRL$new(learning_rate = 0.1, learning_rate_decay = 0.5, lambda = 0,
  l1_ratio = 1, dropout = 0, family = "binomial")}}{Constructor
  for FTRL model. For description of arguments see \bold{Arguments} section.}
  \item{\code{$partial_fit(x, y, ...)}}{fits/updates model
  given input matrix \code{x} and target vector \code{y}.
  \code{x} shape = (n_samples, n_features)}
  \item{\code{$predict(x, ...)}}{predicts output \code{x}}
  \item{\code{$coef()}}{ return coefficients of the regression model}
  \item{\code{$dump()}}{create dump of the model (actually \code{list} with current model parameters)}
  \item{\code{$load(x)}}{load/initialize model from dump)}
}
}

\section{Arguments}{

\describe{
 \item{ftrl}{\code{FTRL} object}
 \item{x}{Input sparse matrix - native format is \code{Matrix::RsparseMatrix}.
 If \code{x} is in different format, model will try to convert it to \code{RsparseMatrix}
 with \code{as(x, "RsparseMatrix")} call}
 \item{learning_rate}{learning rate}
 \item{learning_rate_decay}{learning rate which controls decay. Please refer to FTRL paper for details.
 Usually convergense does not heavily depend on this parameter, so default value 0.5 is safe.}
 \item{lambda}{regularization parameter}
 \item{l1_ratio}{controls L1 vs L2 penalty mixing.
 1 = Lasso regression, 0 = Ridge regression. Elastic net is in between.}
 \item{dropout}{dropout - percentage of random features to
 exclude from each sample. Acts as regularization.}
 \item{family}{ a description of the error distribution and link function to be used in the model.
       Only \code{binomial} (or logistic regression) supported at the moment.}
}
}

\examples{
library(rsparse)
library(Matrix)
i = sample(1000, 1000 * 100, TRUE)
j = sample(1000, 1000 * 100, TRUE)
y = sample(c(0, 1), 1000, TRUE)
x = sample(c(-1, 1), 1000 * 100, TRUE)
odd = seq(1, 99, 2)
x[i \%in\% which(y == 1) & j \%in\% odd] = 1
m = sparseMatrix(i = i, j = j, x = x, dims = c(1000, 1000), giveCsparse = FALSE)
x = as(m, "RsparseMatrix")

ftrl = FTRL$new(learning_rate = 0.01, learning_rate_decay = 0.1,
lambda = 10, l1_ratio = 1, dropout = 0)
ftrl$partial_fit(x, y)

w = ftrl$coef()
head(w)
sum(w != 0)
p = ftrl$predict(m)
}
\keyword{datasets}
