% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.summary.multisimsum.R
\name{autoplot.summary.multisimsum}
\alias{autoplot.summary.multisimsum}
\title{autoplot method for summary.multisimsum objects}
\usage{
\method{autoplot}{summary.multisimsum}(object, par, type = "forest",
  stats = "bias", target = NULL, fitted = TRUE, scales = "fixed",
  ...)
}
\arguments{
\item{object}{An object of class \code{summary.multisimsum}.}

\item{par}{The parameter results to plot.}

\item{type}{The type of the plot to be produced. Possible choices are: \code{forest}, \code{lolly}, \code{zip}, \code{est}, \code{se}, \code{est_ba}, \code{se_ba}, \code{est_ridge}, \code{se_ridge}, with \code{forest} being the default.}

\item{stats}{Summary statistic to plot, defaults to \code{bias}. See \code{\link[=summary.simsum]{summary.simsum()}} for further details on supported summary statistics.}

\item{target}{Target of summary statistic, e.g. 0 for \code{bias}. Defaults to \code{NULL}, in which case target will be inferred.}

\item{fitted}{Superimpose a fitted regression line, useful when \code{type} = (\code{est}, \code{se}, \code{est_ba}, \code{se_ba}). Defaults to \code{TRUE}.}

\item{scales}{Should scales be fixed (\code{fixed}, the default), free (\code{free}), or free in one dimension (\code{free_x}, \code{free_y})?}

\item{...}{Not used.}
}
\value{
A \code{ggplot} object.
}
\description{
autoplot method for summary.multisimsum objects
}
\examples{
data("frailty", package = "rsimsum")
ms <- multisimsum(
  data = frailty,
  par = "par", true = c(trt = -0.50, fv = 0.75),
  estvarname = "b", se = "se", methodvar = "model",
  by = "fv_dist", x = TRUE
)
sms <- summary(ms)

library(ggplot2)
autoplot(sms, par = "trt")
autoplot(sms, par = "trt", type = "lolly", stats = "cover")
autoplot(sms, par = "trt", type = "zip")
autoplot(sms, par = "trt", type = "est_ba")
}
