# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title intime
#'
#' @description Time-adjusted, linear interpolation.
#' @param x matrix with data to interpolate.
#' @param ij Numeric vector with julian days of input data.
#' @param oj Numeric vector with julian days of the output data.
#' @param z Two-element, numeric vector with temporal buffer.
#' @return A matrix.
#' @details {For each row in x, the function finds the two nearest,
#' non NA values to the target dates in ij retrieved before and after
#' this day. Then, the function linearly interpolates the missing value
#' linearly. This function is most suitable when all observation have the
#' same date of recording.}
#' @export
intime <- function(x, ij, oj, z) {
    .Call('_rsMove_intime', PACKAGE = 'rsMove', x, ij, oj, z)
}

#' @title intime2
#'
#' @description Time-adjusted, linear interpolation.
#' @param x matrix with data to interpolate.
#' @param ij Numeric Matrix with julian days of input data.
#' @param oj Numeric vector with julian days of the output data.
#' @param z Two-element, numeric vector with temporal buffer.
#' @return A matrix.
#' @details {For each row in x, the function finds the two nearest,
#' non NA values to the target dates in ij retrieved before and after
#' this day. Then, the function linearly interpolates the missing value
#' linearly. This function is most suitable when all observation have the
#' same date of recording. The function assumes that each observation
#' has its own recording date.}
#' @export
intime2 <- function(x, ij, oj, z) {
    .Call('_rsMove_intime2', PACKAGE = 'rsMove', x, ij, oj, z)
}

#' @title runmean2
#'
#' @description NA-sensitive running mean.
#' @param x A \emph{Numeric} vector.
#' @param y A \emph{numeric} element.
#' @return A vector.
#' @details {Applies a running mean over \emph{x} with a window size defined by \emph{y}.
#' Missing values are ignored and/or filled during the compution.}
#' @export
runmean2 <- function(x, y) {
    .Call('_rsMove_runmean2', PACKAGE = 'rsMove', x, y)
}

