% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_source.R
\name{dbi_table}
\alias{dbi_table}
\title{DBI data source.}
\usage{
dbi_table(db, table_name)
}
\arguments{
\item{db}{database connection}

\item{table_name}{name of table}
}
\value{
a relop representation of the data
}
\description{
Build structures (table name, column names, and quoting
strategy) needed to represent data from a remote table.
}
\details{
Generate a query that returns contents of a table, we
could try to eliminate this (replace the query with the table name),
but there are features one can work with with the query in place and
SQL optimizers likely make this zero-cost anyway.
}
\examples{

if (requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  dbi_copy_to(my_db,
              'd',
              data.frame(AUC = 0.6, R2 = 0.2),
              overwrite = TRUE,
              temporary = TRUE)
  d <- dbi_table(my_db, 'd')
  print(d)
  sql <- to_sql(d, my_db)
  cat(sql)
  print(DBI::dbGetQuery(my_db, sql))
  cols <- columns_used(d)
  print(cols)

  sql2 <- to_sql(d, my_db, using = "AUC")
  cat(sql2)
  print(DBI::dbGetQuery(my_db, sql2))
  DBI::dbDisconnect(my_db)
}

}
\seealso{
\code{\link{table_source}}
}
