% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h5ad.R
\name{writeH5AD}
\alias{writeH5AD}
\alias{writeH5AD.dgCMatrix}
\alias{writeH5AD.ligerDataset}
\alias{writeH5AD.liger}
\title{Write liger object to H5AD files}
\usage{
writeH5AD(object, ...)

\method{writeH5AD}{dgCMatrix}(
  object,
  filename,
  obs = NULL,
  var = NULL,
  overwrite = FALSE,
  verbose = getOption("ligerVerbose", TRUE),
  ...
)

\method{writeH5AD}{ligerDataset}(
  object,
  filename,
  obs = NULL,
  overwrite = FALSE,
  verbose = getOption("ligerVerbose", TRUE),
  ...
)

\method{writeH5AD}{liger}(
  object,
  filename,
  overwrite = FALSE,
  verbose = getOption("ligerVerbose", TRUE),
  ...
)
}
\arguments{
\item{object}{One of \linkS4class{liger}, \linkS4class{ligerDataset} or
\link[Matrix]{dgCMatrix-class} object.}

\item{...}{Arguments passed down to S3 methods}

\item{filename}{A character string, the path to the H5AD file to be written}

\item{obs}{External data.frame that contains metadata of the cells but does
not embed inside the object. Rownames must be identical to the colnames of
object.}

\item{var}{External data.frame that contains metadata of the features but
does not embed inside the object. Rownames must be identical to the rownames
of object.}

\item{overwrite}{Logical, whether to overwrite the file if it exists.}

\item{verbose}{Logical. Whether to show information of the progress. Default
\code{getOption("ligerVerbose")} which is \code{TRUE} if users have not set.}
}
\value{
No return value, an H5AD file is written to disk with the following
specification, assuming the file is loaded to \code{adata} in Python:
\itemize{
\item{\code{adata.X} - Raw count CSR matrix, outer joined with all
datasets}
\item{\code{adata.obs} - Cell metadata, with exactly same content of
\code{cellMeta(object)}}
\item{\code{adata.var} - Feature metadata containing only the feature names
as the index of \code{pd.DataFrame}.}
\item{\code{adata.obsm['X_inmf_aligned']} - The integrated embedding,
aligned cell factor loading matrix, the primary output of LIGER, if
available.}
\item{\code{adata.obsm['X_inmf']} - The raw cell factor loading matrix, if
available.}
\item{\code{adata.obsm['<dimRedName>']} - The dimensional reduction matrix,
such as UMAP or TSNE, if available.}
\item{\code{adata.uns['inmf']['W']} - The shared factor feature loading
matrix, if available.}
\item{\code{adata.uns['inmf']['V']['<datasetName>']} - The dataset-specific
factor feature loading matrix, if available.}
\item{\code{adata.uns['inmf']['features']} - The variable features being
used for factorization, supposed to match to the second shape of W and V,
if available.}
\item{\code{adata.uns['inmf']['lambda']} - The hyperparameter lambda used,
the regularization parameter for the factorization, if available.}
\item{\code{adata.uns['inmf']['k']} - The number of factors used for the
factorization, if available.}
}
}
\description{
Create an H5AD file from a \linkS4class{liger} object. This function writes
only raw counts to \code{adata.X}, while normalized and scaled expression
data will not be written, because LIGER use different normalization and
scaling strategy than most of the other tools utilizing H5AD format.

Supports for single sparse matrices or internal \linkS4class{ligerDataset}
objects are also provided if there is a need to convert single datasets.
}
\examples{
print("The example below works, but causes PDF manual rendering issue for some reason")
\dontrun{
writeH5AD(pbmc, filename = tempfile(fileext = ".h5ad"))
}
}
