% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/drop_delta.R
\name{drop_delta}
\alias{drop_delta}
\title{Get a list of Deltas}
\usage{
drop_delta(cursor = NULL, locale = NULL, path_prefix = NULL,
  include_media_info = NULL, dtoken = get_dropbox_token())
}
\arguments{
\item{cursor}{The last cursor}

\item{locale}{Dropbox uses the locale parameter to specify language settings
of content responses. If your app supports any language other than English,
insert the appropriate IETF language tag. When a supported language is
specified, Dropbox will returned translated size and/or user_error fields
(where applicable)}

\item{path_prefix}{The path to subset}

\item{include_media_info}{Set to \code{TRUE}}

\item{dtoken}{The Dropbox token generated by \code{\link{drop_auth}}.
rdrop2 will try to automatically locate your local credential cache and use
them. However, if the credentials are not found, the function will initiate
a new authentication request. You can override this by pointing to a
different location where your credentials are stored.}
}
\description{
Get a list of Deltas
}
\examples{
\dontrun{
z <- drop_delta(path_prefix = "/Public")
# If no files have changed during this time, entries will be NULL
drop_delta(cursor = z$cursor, path_prefix = "/Public")
}
}

