% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{add.dates}
\alias{add.dates}
\title{Add dates to age-depth plots}
\usage{
add.dates(
  mn,
  sdev,
  depth,
  cc = 1,
  set = get("info"),
  above = 1e-06,
  postbomb = 0,
  normal = TRUE,
  delta.R = 0,
  delta.STD = 0,
  t.a = set$t.a,
  t.b = set$t.b,
  date.res = 100,
  height = 1,
  calheight = 1,
  agesteps = 1,
  cutoff = 0.005,
  col = rgb(1, 0, 0, 0.5),
  border = rgb(1, 0, 0, 0.5),
  rotate.axes = FALSE,
  mirror = TRUE,
  up = TRUE,
  BCAD = FALSE,
  pch = 4,
  cc.dir = c()
)
}
\arguments{
\item{mn}{Reported mean of the date. Can be multiple dates. Negative numbers indicate postbomb dates (if cc > 0).}

\item{sdev}{Reported error of the date. Can be multiple dates.}

\item{depth}{Depth of the date.}

\item{cc}{The calibration curve to use: \code{cc=1} for IntCal20 (northern hemisphere terrestrial), \code{cc=2} for Marine20 (marine), \code{cc=0} for none (dates that are already on the cal BP scale).}

\item{set}{Detailed information of the current run, stored within this session's memory as variable \code{info}.}

\item{above}{Threshold for plotting of probability values. Defaults to \code{above=1e-3}.}

\item{postbomb}{Use a postbomb curve for negative (i.e. postbomb) 14C ages. \code{0 = none, 1 = NH1, 2 = NH2, 3 = NH3, 4 = SH1-2, 5 = SH3}}

\item{normal}{By default, Bacon uses the t-distribution (Christen and Perez 2009) to treat the dates. Use \code{normal=TRUE} to use the normal/Gaussian distribution. This will generally give higher weight to the dates.}

\item{delta.R}{Mean of core-wide age offsets (e.g., regional marine offsets).}

\item{delta.STD}{Error of core-wide age offsets (e.g., regional marine offsets).}

\item{t.a}{The dates are treated using the t distribution by default (\code{normal=FALSE}).
The t model has two parameters, t.a and t.b, set at 3 and 4 by default (see Christen and Perez, 2010).
If you want to assign narrower error distributions (more closely resembling the normal distribution), set t.a and t.b at for example 33 and 34 respectively (e.g., for specific dates in your .csv file).
For symmetry reasons, t.a must always be equal to t.b-1.}

\item{t.b}{The dates are treated using the t distribution by default (\code{normal=FALSE}).
The t-distribution has two parameters, t.a and t.b, set at 3 and 4 by default (see Christen and Perez, 2010).
If you want to assign narrower error distributions (more closely resembling the normal distribution), set t.a and t.b at for example 33 and 34 respectively (e.g., for specific dates in your .csv file).
For symmetry reasons, t.a must always be equal to t.b-1.}

\item{date.res}{Resolution of the date's distribution. Defaults to \code{date.res=100}.}

\item{height}{The heights of the distributions of the dates. See also \code{normalise.dists}.}

\item{calheight}{Multiplier for the heights of the distributions of dates on the calendar scale. Defaults to \code{calheight=1}.}

\item{agesteps}{Step size for age units of the distribution. Default \code{agesteps=1}.}

\item{cutoff}{Avoid plotting very low probabilities of date distributions (default \code{cutoff=0.005}).}

\item{col}{The colour of the ranges of the date. Default is semi-transparent red: \code{col=rgb(1,0,0,.5)}.}

\item{border}{The colours of the borders of the date. Default is semi-transparent red: \code{border=rgb(1,0,0,0.5)}.}

\item{rotate.axes}{The default of plotting age on the horizontal axis and event probability on the vertical one can be changed with \code{rotate.axes=TRUE}.}

\item{mirror}{Plot the dates as 'blobs'. Set to \code{mirror=FALSE} to plot simple distributions.}

\item{up}{Directions of distributions if they are plotted non-mirrored. Default \code{up=TRUE}.}

\item{BCAD}{The calendar scale of graphs is in \code{cal BP} by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}

\item{pch}{The shape of any marker to be added to the date. Defaults to a cross, \code{pch=4}. To leave empty, use \code{pch=NA}.}

\item{cc.dir}{Directory where the calibration curves for C14 dates \code{cc} are located. By default \code{cc.dir=c()}.}
}
\value{
A date's distribution, added to an age-depth plot.
}
\description{
Add dated depths to plots, e.g. to show dates that weren't used in the age-depth model
}
\details{
Sometimes it is useful to add additional dating information to age-depth plots, e.g., to show outliers or how dates calibrate with different estimated offsets. Calls rice's draw.dates function.
}
\examples{
\donttest{
  Bacon(run=FALSE, coredir=tempfile())
  agedepth()
  add.dates(5000, 100, 60)
}
}
\author{
Maarten Blaauw, J. Andres Christen
}
