/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyList;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.imp;
import org.python.core.util.RelativeFile;
import org.python.modules._systemrestart;
import org.python.modules.thread.thread;
import org.python.util.CommandLineOptions;
import org.python.util.InteractiveConsole;

public class jython {
    private static final String COPYRIGHT = "Type \"help\", \"copyright\", \"credits\" or \"license\" for more information.";
    static final String usageHeader = "usage: jython [option] ... [-c cmd | -m mod | file | -] [arg] ...\n";
    private static final String usage = "usage: jython [option] ... [-c cmd | -m mod | file | -] [arg] ...\nOptions and arguments:\n-c cmd   : program passed in as string (terminates option list)\n-Dprop=v : Set the property `prop' to value `v'\n-C codec : Use a different codec when reading from the console.\n-h       : print this help message and exit (also --help)\n-i       : inspect interactively after running script\n           and force prompts, even if stdin does not appear to be a terminal\n-jar jar : program read from __run__.py in jar file\n-m mod   : run library module as a script (terminates option list)\n-Q arg   : division options: -Qold (default), -Qwarn, -Qwarnall, -Qnew\n-S       : don't imply 'import site' on initialization\n-u       : unbuffered binary stdout and stderr\n-v       : verbose (trace import statements)\n-V       : print the Python version number and exit (also --version)\n-W arg   : warning control (arg is action:message:category:module:lineno)\nfile     : program read from script file\n-        : program read from stdin (default; interactive mode if a tty)\narg ...  : arguments passed to program in sys.argv[1:]\nOther environment variables:\nJYTHONPATH: '" + File.pathSeparator + "'-separated list of directories prefixed to the default module\n" + "            search path.  The result is sys.path.";
    public static boolean shouldRestart;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runJar(String filename) {
        try {
            PyCode code;
            ZipFile zip = new ZipFile(filename);
            ZipEntry runit = zip.getEntry("__run__.py");
            if (runit == null) {
                throw Py.ValueError("jar file missing '__run__.py'");
            }
            PyStringMap locals = new PyStringMap();
            int beginIndex = filename.lastIndexOf(File.separator);
            if (beginIndex != -1) {
                filename = filename.substring(beginIndex + 1);
            }
            locals.__setitem__("__name__", (PyObject)new PyString(filename));
            locals.__setitem__("zipfile", Py.java2py(zip));
            InputStream file = zip.getInputStream(runit);
            try {
                code = (PyCode)Py.compile(file, "__run__", "exec");
            }
            finally {
                file.close();
            }
            Py.runCode(code, locals, locals);
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
    }

    public static void main(String[] args) {
        do {
            shouldRestart = false;
            jython.run(args);
        } while (shouldRestart);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void run(String[] args) {
        InteractiveConsole interp;
        CommandLineOptions opts;
        block47: {
            block48: {
                block49: {
                    String path;
                    block46: {
                        opts = new CommandLineOptions();
                        if (!opts.parse(args)) {
                            if (opts.version) {
                                PySystemState.determinePlatform(System.getProperties());
                                System.err.println(InteractiveConsole.getDefaultBanner());
                                System.exit(0);
                            }
                            if (!opts.runModule) {
                                System.err.println(usage);
                            }
                            int exitcode = opts.help ? 0 : -1;
                            System.exit(exitcode);
                        }
                        PySystemState.initialize(PySystemState.getBaseProperties(), opts.properties, opts.argv);
                        interp = jython.newInterpreter();
                        PySystemState.warnoptions = new PyList();
                        for (String wopt : opts.warnoptions) {
                            PySystemState.warnoptions.append(new PyString(wopt));
                        }
                        if (!opts.fixInteractive && opts.interactive) {
                            opts.interactive = ((PyFile)Py.defaultSystemState.stdin).isatty();
                            if (!opts.interactive) {
                                PySystemState systemState = Py.getSystemState();
                                systemState.ps1 = systemState.ps2 = new PyString();
                            }
                        }
                        if (opts.interactive && opts.notice && !opts.runModule) {
                            System.err.println(InteractiveConsole.getDefaultBanner());
                        }
                        if (Options.importSite) {
                            try {
                                imp.load("site");
                                if (opts.interactive && opts.notice && !opts.runModule) {
                                    System.err.println(COPYRIGHT);
                                }
                            }
                            catch (PyException pye) {
                                if (Py.matchException(pye, Py.ImportError)) break block46;
                                System.err.println("error importing site");
                                Py.printException(pye);
                                System.exit(-1);
                            }
                        }
                    }
                    if (opts.division != null) {
                        if ("old".equals(opts.division)) {
                            Options.divisionWarning = 0;
                        } else if ("warn".equals(opts.division)) {
                            Options.divisionWarning = 1;
                        } else if ("warnall".equals(opts.division)) {
                            Options.divisionWarning = 2;
                        } else if ("new".equals(opts.division)) {
                            Options.Qnew = true;
                            interp.cflags.division = true;
                        }
                    }
                    if (opts.filename == null) break block48;
                    try {
                        path = new File(opts.filename).getCanonicalFile().getParent();
                    }
                    catch (IOException ioe) {
                        path = new File(opts.filename).getAbsoluteFile().getParent();
                    }
                    if (path == null) {
                        path = "";
                    }
                    Py.getSystemState().path.insert(0, new PyString(path));
                    if (!opts.jar) break block49;
                    jython.runJar(opts.filename);
                    break block47;
                }
                if (opts.filename.equals("-")) {
                    try {
                        interp.locals.__setitem__(new PyString("__file__"), (PyObject)new PyString("<stdin>"));
                        interp.execfile(System.in, "<stdin>");
                    }
                    catch (Throwable t) {
                        Py.printException(t);
                    }
                    break block47;
                } else {
                    try {
                        FileInputStream file;
                        interp.locals.__setitem__(new PyString("__file__"), (PyObject)new PyString(opts.filename));
                        try {
                            file = new FileInputStream(new RelativeFile(opts.filename));
                        }
                        catch (FileNotFoundException e) {
                            throw Py.IOError(e);
                        }
                        if (imp.load("os").__getattr__("isatty").__call__(Py.java2py(file.getFD())).__nonzero__()) {
                            opts.interactive = true;
                            interp.interact(null, new PyFile(file));
                            System.exit(0);
                            break block47;
                        }
                        interp.execfile(file, opts.filename);
                    }
                    catch (Throwable t) {
                        if (t instanceof PyException && Py.matchException((PyException)t, _systemrestart.SystemRestart)) {
                            shouldRestart = true;
                            jython.shutdownInterpreter();
                            Py.setSystemState(new PySystemState());
                            break block47;
                        }
                        Py.printException(t);
                        if (!opts.interactive) {
                            interp.cleanup();
                            System.exit(-1);
                        }
                        break block47;
                    }
                }
            }
            Py.getSystemState().path.insert(0, new PyString(""));
            if (opts.command != null) {
                try {
                    interp.exec(opts.command);
                }
                catch (Throwable t) {
                    Py.printException(t);
                }
            }
            if (opts.moduleName != null) {
                try {
                    interp.exec("import runpy");
                    interp.set("name", Py.newString(opts.moduleName));
                    interp.exec("runpy.run_module(name, run_name='__main__', alter_sys=True)");
                    interp.cleanup();
                    System.exit(0);
                }
                catch (Throwable t) {
                    Py.printException(t);
                    interp.cleanup();
                    System.exit(0);
                }
            }
        }
        if (opts.fixInteractive || opts.filename == null && opts.command == null) {
            if (opts.encoding == null) {
                opts.encoding = PySystemState.registry.getProperty("python.console.encoding", null);
            }
            if (opts.encoding != null) {
                if (!Charset.isSupported(opts.encoding)) {
                    System.err.println(opts.encoding + " is not a supported encoding on this JVM, so it can't be used in python.console.encoding.");
                    System.exit(1);
                }
                interp.cflags.encoding = opts.encoding;
            }
            try {
                interp.interact(null, null);
            }
            catch (Throwable t) {
                Py.printException(t);
            }
        }
        interp.cleanup();
        if (opts.fixInteractive || opts.interactive) {
            System.exit(0);
        }
    }

    private static InteractiveConsole newInterpreter() {
        InteractiveConsole interp = null;
        try {
            String interpClass = PySystemState.registry.getProperty("python.console", "org.python.util.InteractiveConsole");
            interp = (InteractiveConsole)Class.forName(interpClass).newInstance();
        }
        catch (Exception e) {
            interp = new InteractiveConsole();
        }
        PyModule mod = imp.addModule("__main__");
        interp.setLocals(mod.__dict__);
        return interp;
    }

    public static void shutdownInterpreter() {
        thread.interruptAllThreads();
        try {
            imp.load("socket").__findattr__("_closeActiveSockets").__call__();
        }
        catch (PyException pyException) {
            // empty catch block
        }
    }
}

