/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PySlice$PyExposer;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.expose.ExposedNew;

public class PySlice
extends PyObject {
    public static final PyType TYPE;
    public PyObject start = Py.None;
    public PyObject stop = Py.None;
    public PyObject step = Py.None;

    public PySlice() {
        this(TYPE);
    }

    public PySlice(PyType type) {
        super(type);
    }

    public PySlice(PyObject start, PyObject stop, PyObject step) {
        this(TYPE);
        if (start != null) {
            this.start = start;
        }
        if (stop != null) {
            this.stop = stop;
        }
        if (step != null) {
            this.step = step;
        }
    }

    @ExposedNew
    final void slice___init__(PyObject[] args, String[] keywords) {
        if (args.length == 0) {
            throw Py.TypeError("slice expected at least 1 arguments, got " + args.length);
        }
        if (args.length > 3) {
            throw Py.TypeError("slice expected at most 3 arguments, got " + args.length);
        }
        ArgParser ap = new ArgParser("slice", args, keywords, "start", "stop", "step");
        if (args.length == 1) {
            this.stop = ap.getPyObject(0);
        } else if (args.length == 2) {
            this.start = ap.getPyObject(0);
            this.stop = ap.getPyObject(1);
        } else if (args.length == 3) {
            this.start = ap.getPyObject(0);
            this.stop = ap.getPyObject(1);
            this.step = ap.getPyObject(2);
        }
    }

    public int hashCode() {
        return this.slice___hash__();
    }

    final int slice___hash__() {
        throw Py.TypeError(String.format("unhashable type: '%.200s'", this.getType().fastGetName()));
    }

    public PyString __str__() {
        return new PyString(this.getStart().__repr__() + ":" + this.getStop().__repr__() + ":" + this.getStep().__repr__());
    }

    public PyString __repr__() {
        return new PyString("slice(" + this.getStart().__repr__() + ", " + this.getStop().__repr__() + ", " + this.getStep().__repr__() + ")");
    }

    public PyObject __eq__(PyObject o) {
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        if (this == o) {
            return Py.True;
        }
        PySlice oSlice = (PySlice)o;
        if (PySlice.eq(this.getStart(), oSlice.getStart()) && PySlice.eq(this.getStop(), oSlice.getStop()) && PySlice.eq(this.getStep(), oSlice.getStep())) {
            return Py.True;
        }
        return Py.False;
    }

    private static final boolean eq(PyObject o1, PyObject o2) {
        return o1._cmp(o2) == 0;
    }

    public PyObject __ne__(PyObject o) {
        return this.__eq__(o).__not__();
    }

    public PyObject indices(PyObject len) {
        return this.slice_indices(len);
    }

    final PyObject slice_indices(PyObject len) {
        int[] indices = this.indicesEx(len.asIndex(Py.OverflowError));
        return new PyTuple(Py.newInteger(indices[0]), Py.newInteger(indices[1]), Py.newInteger(indices[2]));
    }

    public int[] indicesEx(int len) {
        int stop;
        int start;
        int step;
        if (this.getStep() == Py.None) {
            step = 1;
        } else {
            step = PySlice.calculateSliceIndex(this.getStep());
            if (step == 0) {
                throw Py.ValueError("slice step cannot be zero");
            }
        }
        if (this.getStart() == Py.None) {
            start = step < 0 ? len - 1 : 0;
        } else {
            start = PySlice.calculateSliceIndex(this.getStart());
            if (start < 0) {
                start += len;
            }
            if (start < 0) {
                int n = start = step < 0 ? -1 : 0;
            }
            if (start >= len) {
                int n = start = step < 0 ? len - 1 : len;
            }
        }
        if (this.getStop() == Py.None) {
            stop = step < 0 ? -1 : len;
        } else {
            stop = PySlice.calculateSliceIndex(this.getStop());
            if (stop < 0) {
                stop += len;
            }
            if (stop < 0) {
                stop = -1;
            }
            if (stop > len) {
                stop = len;
            }
        }
        int slicelength = step < 0 && stop >= start || step > 0 && start >= stop ? 0 : (step < 0 ? (stop - start + 1) / step + 1 : (stop - start - 1) / step + 1);
        return new int[]{start, stop, step, slicelength};
    }

    public static PyObject[] indices2(PyObject obj, PyObject start, PyObject stop) {
        int istop;
        int istart;
        PyObject[] indices;
        block5: {
            indices = new PyObject[2];
            istart = start == null || start == Py.None ? 0 : PySlice.calculateSliceIndex(start);
            int n = istop = stop == null || stop == Py.None ? PySystemState.maxint : PySlice.calculateSliceIndex(stop);
            if (istart < 0 || istop < 0) {
                try {
                    int len = obj.__len__();
                    if (istart < 0) {
                        istart += len;
                    }
                    if (istop < 0) {
                        istop += len;
                    }
                }
                catch (PyException pye) {
                    if (Py.matchException(pye, Py.AttributeError)) break block5;
                    throw pye;
                }
            }
        }
        indices[0] = Py.newInteger(istart);
        indices[1] = Py.newInteger(istop);
        return indices;
    }

    public static int calculateSliceIndex(PyObject v) {
        if (v.isIndex()) {
            return v.asIndex();
        }
        throw Py.TypeError("slice indices must be integers or None or have an __index__ method");
    }

    public final PyObject getStart() {
        return this.start;
    }

    public final PyObject getStop() {
        return this.stop;
    }

    public final PyObject getStep() {
        return this.step;
    }

    static {
        PyType.addBuilder(PySlice.class, new PySlice$PyExposer());
        TYPE = PyType.fromClass(PySlice.class);
    }
}

