% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/target_market_share.R
\name{target_market_share}
\alias{target_market_share}
\title{Add targets for production, using the market share approach}
\usage{
target_market_share(
  data,
  ald,
  scenario,
  region_isos = r2dii.data::region_isos,
  use_credit_limit = FALSE,
  by_company = FALSE
)
}
\arguments{
\item{data}{A "data.frame" like the output of
\code{\link[r2dii.match:prioritize]{r2dii.match::prioritize()}}.}

\item{ald}{An asset level data frame like \link[r2dii.data:ald_demo]{r2dii.data::ald_demo}.}

\item{scenario}{A scenario data frame like \link[r2dii.data:scenario_demo_2020]{r2dii.data::scenario_demo_2020}.}

\item{region_isos}{A data frame like \link[r2dii.data:region_isos]{r2dii.data::region_isos} (default).}

\item{use_credit_limit}{Logical vector of length 1. \code{FALSE} defaults to using
the column \code{loan_size_outstanding}. Set to \code{TRUE} to use the column
\code{loan_size_credit_limit} instead.}

\item{by_company}{Logical vector of length 1. \code{FALSE} defaults to outputting
\code{weighted_production_value} at the portfolio-level. Set to \code{TRUE} to output
\code{weighted_production_value} at the company-level.}
}
\value{
A tibble with the summarized columns \code{weighted_production_metric}
and \code{weighted_production_value}. If \code{by_company = TRUE}, the output will also
have the column \code{name_ald}.
}
\description{
This function calculates the portfolio-level production targets, as
calculated using the market share approach applied to each relevant climate
production forecast.
}
\section{Handling grouped data}{

This function ignores existing groups and outputs ungrouped data.
}

\examples{
library(r2dii.analysis)
library(r2dii.data)
library(r2dii.match)

match_result <- r2dii.data::loanbook_demo \%>\%
  r2dii.match::match_name(r2dii.data::ald_demo) \%>\%
  r2dii.match::prioritize()

# calculate targets at portfolio level
target_market_share(match_result,
  ald = r2dii.data::ald_demo,
  scenario = r2dii.data::scenario_demo_2020,
  region_isos = r2dii.data::region_isos_demo
)

# calculate targets at company level
target_market_share(match_result,
  ald = r2dii.data::ald_demo,
  scenario = r2dii.data::scenario_demo_2020,
  region_isos = r2dii.data::region_isos_demo,
  by_company = TRUE
)

}
\seealso{
Other functions to calculate scenario targets: 
\code{\link{target_sda}()}
}
\concept{functions to calculate scenario targets}
