% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpNCA.r
\name{qpNCA}
\alias{qpNCA}
\title{Perform Non-compartmental Analysis}
\usage{
qpNCA(
  x,
  by = character(0),
  nomtimevar = "ntad",
  timevar = "time",
  depvar = "dv",
  bloqvar = "bloq",
  loqvar = "loq",
  loqrule = 1,
  includeCmax = "Y",
  exclvar = NA,
  plotdir = NA,
  timelab = "timevar",
  deplab = "depvar",
  tau = NA,
  tstart = NA,
  tend = NA,
  teval = NA,
  covariates = NA,
  dose = "dose",
  factor = 1,
  reg = "SD",
  ss = "N",
  route = "EV",
  method = 1
)
}
\arguments{
\item{x}{input dataset name}

\item{by}{column names in x indicating grouping variables}

\item{nomtimevar}{variable name containing the nominal sampling time after dose}

\item{timevar}{variable name containing the actual sampling time after dose}

\item{depvar}{variable name containing the dependent variable (e.g., concentration)}

\item{bloqvar}{variable name containing the BLOQ flag (0: no, 1: yes)}

\item{loqvar}{variable name containing the LOQ value}

\item{loqrule}{rule number to be applied to the LOQ values in the curve; x$loqrule overrides if provided}

\item{includeCmax}{include Cmax in half-life estimation? (y/n); x$includeCmax overrides if provided}

\item{exclvar}{variable name indicating points to be excluded in half-life estimation (these should have exclvar = 1)}

\item{plotdir}{directory where regression plots (.PNG) will be saved; NA gives default location, NULL skips regression plots}

\item{timelab}{label for time axis in regression plots}

\item{deplab}{label for dependent variable axis in regression plots}

\item{tau}{dosing interval (for multiple dosing); NA (default) if single dose; x$tau overrides}

\item{tstart}{start time of partial AUC (start>0); NA (default) if not requested; x$tstart overrides}

\item{tend}{end time of partial AUC; NA (default) if not requested; x$tend overrides}

\item{teval}{user selected AUC interval (starting at t=0); NA (default) if not requested; x$teval overrides}

\item{covariates}{covariates dataset; Must contain the dose variable}

\item{dose}{variable containing the dose amount}

\item{factor}{conversion factor for CL and V calculation (e.g. dose in mg, conc in ng/mL, factor=1000); x$factor overrides if provided}

\item{reg}{regimen, "SD" or "MD"; x$reg overrides if provided}

\item{ss}{is steady state reached (y/n); x$ss overrides if provided}

\item{route}{route of drug administration ("EV","IVB", "IVI"); x$route overrides if provided}

\item{method}{method for trapezoidal rule; x$method overrides if provided
\itemize{
\item 1: linear up - linear down
\item 2: linear up - logarithmic down
\item 3: linear before first Tmax, logarithmic after first Tmax
}}
}
\value{
(list)
\itemize{
\item \strong{covariates} covariates selected with the \code{covariates} argument
\item \strong{half_life} linear regression parameters
\item \strong{ct_corr} the time and concentration corrected dataset
\item \strong{corrections} descriptions of the corrections applied
\item \strong{pkpar} all estimated PK parameters
\item \strong{plots} generated plots
}
}
\description{
Consecutively executes the following NCA steps:
\itemize{
\item \link{correct.loq} impute LOQ values
\item \link{est.thalf} calculate lambda_z and half-life
\item \link{plot_reg} plot each regression curve
\item \link{calc.ctmax} calculate Cmax and Tmax
\item \link{correct.time} correct time deviations at critical time points
\item \link{correct.conc} impute missing concentrations at critical time points
\item \link{tab.corr} tabulate data alterations
\item \link{calc.par} calculates parameters not dependent on lambda_z
\item \link{calc.par.th} calculates parameters dependent on lambda_z
}
}
\examples{
\donttest{
library(magrittr)
library(dplyr)
library(qpNCA)
x <- Theoph
ntad <- c(0,0.25,0.5,1,2,4,5,7,9,12,24)
for(i in 1:nrow(x)){
  time  <- x$Time[[i]]
  delta <- abs(ntad - time)
  best  <- min(delta)
  index <- match(best, delta)
  nom   <- ntad[[index]]
  x$ntad[[i]] <- nom
}
rm(list = c('time','delta','best','index','nom', 'i','ntad'))
x \%<>\% rename(time = Time, dv = conc, subject = Subject)
x \%<>\% mutate(bloq = 0, loq = 0.01, tad = time,excl_th=0,
              subject=as.numeric(subject),ntad=as.numeric(ntad))
x \%<>\% filter(dv > 0)
covs <- x \%>\%
  select(subject, Wt, dose = Dose) \%>\%
  distinct(subject,.keep_all=TRUE) \%>\%
  mutate(dose = dose * Wt) # see ?Theoph
z <- qpNCA(x, by = 'subject', covariates = covs, exclvar='excl_th')
}
}
