% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct.time.r
\name{correct.time}
\alias{correct.time}
\title{Correct Concentrations for Time Deviations}
\usage{
correct.time(
  x,
  by = character(0),
  nomtimevar = "ntad",
  timevar = "time",
  depvar = "dv",
  tau = NA,
  tstart = NA,
  tend = NA,
  teval = NA,
  th = NA,
  reg = "SD",
  method = 1
)
}
\arguments{
\item{x}{input dataset name (after LOQ values have been imputed by \code{\link{correct.loq}})}

\item{by}{column names in x indicating grouping variables}

\item{nomtimevar}{variable name containing the nominal sampling time after dose}

\item{timevar}{variable name containing the actual sampling time after dose}

\item{depvar}{variable name containing the dependent variable (e.g., concentration)}

\item{tau}{dosing interval (for multiple dosing); NA (default) if single dose; x$tau overrides}

\item{tstart}{start time of partial AUC (start>0); NA (default) if not requested; x$tstart overrides}

\item{tend}{end time of partial AUC; NA (default) if not requested; x$tend overrides}

\item{teval}{user selected AUC interval, starting at t=0; NA (default) if not requested; x$teval overrides}

\item{th}{lamdba_z information for each curve; like output of \code{\link{est.thalf}}}

\item{reg}{regimen, "sd" or "md"; x$reg overrides}

\item{method}{method for trapezoidal rule;  x$method overrides if provided
\itemize{
\item 1: linear up - linear down
\item 2: linear up - logarithmic down
\item 3: linear before first Tmax, logarithmic after first Tmax
}}
}
\value{
a dataset with time deviation corrections applied (timevar and depvar adapted).
The following variables are added:\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   create.nr \tab is a missing record created? \cr
   create.txt \tab explanation of what is created \cr
   trule.nr \tab correction rule number \cr
   trule.txt \tab text explaining what was altered \cr
   applies.to.time \tab lists all critical time points to which the time deviation rule applies \cr
   time.tau, conc.tau \tab time and conc, corrected for AUCtau calculation \cr
   time.teval, conc.teval \tab time and conc, corrected for AUCteval calculation (AUC0-teval) \cr
   time.part, conc.part \tab time and conc, corrected for partial AUC calculation (AUCstart-end, start>0) \cr
   time.lastall, conc.lastall \tab time and conc, corrected for AUClast and AUCall calculation \cr
   t0.flag, tau.flag, tstart.flag, tend.flag, teval.flag \tab flags for what timepoint the correction was needed \cr
}


The following are preserved if present in x: tau, tstart, tend, teval, reg, ss, route, method.
}
\description{
Corrects concentrations at critical, but deviating time points
(e.g, predose, TAU, start and end of user selected AUC interval),
and adds missing records at these critical time points.
}
\details{
\itemize{
\item Records with missing NOMINAL time will be removed and this must be corrected before the function is called
\item If a record at the critical time point is missing, add it and set time to nominal time and set dv conc to NA
\item Use interpolation if there is a measurable concentration AFTER the nominal time point (i.e. sample is taken too late)
\item Use extrapolation if there is NO measurable concentration AFTER the nominal time point (i.e. sample is taken too early)
\item Set deviating time at predose after single dose to 0
\item Original time and conc will be kept in original variables.
}

The following Time Deviation Correction Rules will be applied to critical time points (t = 0, tau, tstart, tend, teval), if needed:\tabular{llll}{
   \strong{Rule} \tab \strong{Regimen} \tab \strong{Description} \tab \strong{Applied to} \cr
   SDT-1 \tab sd \tab Set actual time to 0 \tab t = 0 \cr
   SDT-2 \tab sd \tab Correct concentration at deviating time by interpolation \tab t = tau,tstart,tend,teval \cr
   SDT-3 \tab sd \tab Correct concentration at deviating time by extrapolation \tab t = tau,tend,teval \cr
   MDT-1 \tab md \tab If predose sample taken after dosing, set actual time to 0 and conc to NA \tab t = 0 \cr
   MDT-2 \tab md \tab Correct concentration at deviating time by interpolation (too late) \tab t = tau,tstart,tend,teval \cr
   MDT-3 \tab md \tab Correct concentration at deviating time by extrapolation (too early) \tab t = 0,tau,tend,teval \cr
   MDT-3a \tab md \tab Set actual time to zero if concentration is BLOQ (too early) \tab t = 0 \cr
}
}
\examples{
\donttest{
example(calc.ctmax)
x \%<>\% mutate(reg = 'SD', method = 1, route = 'EV')
# route not used yet, but still preserved
x \%<>\% correct.time(by = 'subject', th = th)
x \%>\% head
}
}
