% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct.loq.r
\name{correct.loq}
\alias{correct.loq}
\title{Impute Concentrations Below the Limit of Quantitation}
\usage{
correct.loq(
  x,
  by = character(0),
  nomtimevar = "ntad",
  timevar = "time",
  depvar = "dv",
  bloqvar = "bloq",
  loqvar = "loq",
  loqrule = 1
)
}
\arguments{
\item{x}{input dataset name contains all uncorrected data, including LOQ}

\item{by}{column names in x indicating grouping variables}

\item{nomtimevar}{variable name containing the nominal sampling time after dose}

\item{timevar}{variable name containing the actual sampling time after dose}

\item{depvar}{variable name containing the dependent variable (e.g., concentration)}

\item{bloqvar}{variable name containing the BLOQ flag (0: no, 1: yes)}

\item{loqvar}{variable name containing the LOQ value}

\item{loqrule}{rule number to be applied to the LOQ values in the curve. x$loqrule overrides if provided
\itemize{
\item 1: 0 before first measurable concentration (FMC); NA after FMC
\item 2: 0 before FMC; 0 after FMC
\item 3: 0 before FMC; 0.5xLOQ for first consecutive LOQ after FMC, NA for other LOQ
\item 4: 0 before FMC; 0.5xLOQ for first consecutive LOQ after FMC, 0 for other LOQ
}}
}
\value{
A dataset with imputed BLOQ concentrations using the chosen imputation rule
}
\description{
Imputes LOQ values according to the chosen LOQ substitution rule.
}
\details{
Imputations will be applied to the original depvar (no new concentration
variable will be created).
}
\examples{
\donttest{
library(magrittr)
library(dplyr)
library(qpNCA)
x <- Theoph
ntad <- c(0,0.25,0.5,1,2,4,5,7,9,12,24)
for(i in 1:nrow(x)){
  time  <- x$Time[[i]]
  delta <- abs(ntad - time)
  best  <- min(delta)
  index <- match(best, delta)
  nom   <- ntad[[index]]
  x$ntad[[i]] <- nom
}
rm(list = c('time','delta','best','index','nom', 'i','ntad'))
x \%<>\% rename(time = Time, dv = conc)
x \%<>\% mutate(bloq = ifelse(dv==0,1,0), loq = 0.01, tad = time, loqrule = 1, 
              subject=as.numeric(Subject), ntad=as.numeric(ntad))
x \%>\% head
x \%<>\% correct.loq('subject')
x \%>\%  head
}
}
