% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.par.r
\name{calc.par}
\alias{calc.par}
\title{Calculate NCA Parameters}
\usage{
calc.par(
  x,
  by = character(0),
  tau = NA,
  tstart = NA,
  tend = NA,
  teval = NA,
  route = "EV",
  method = 1
)
}
\arguments{
\item{x}{contains all data after time/concentration deviation corrections obtained from \code{\link{correct.time}} and \code{\link{correct.conc}}}

\item{by}{column names in x indicating grouping variables}

\item{tau}{dosing interval (for multiple dosing); NA (default) for if single dose; x$tau overrides}

\item{tstart}{start time of partial AUC (start>0); NA (default) if not requested; x$tstart overrides}

\item{tend}{end time of partial AUC; NA (default) if not requested; x$tend overrides}

\item{teval}{user selected AUC interval; NA (default) if not requested; x$teval overrides}

\item{route}{route of drug administration ("EV","IVB","IVI"); x$route overrides}

\item{method}{method for trapezoidal rule
\itemize{
\item 1: linear up - linear down
\item 2: linear up - logarithmic down
\item 3: linear before first Tmax, logarithmic after first Tmax
}}
}
\value{
A dataset with estimates for the following parameters,
one observation per subject:\tabular{ll}{
   \strong{Parameter} \tab \strong{Description} \cr
   t0.ok \tab flags if t=0 concentration could be corrected/imputes. If not, no AUCs starting at t=0 are calculated \cr
   tlast.ok \tab flags if there is at least one measurable concentration. If not, no AUClast can be calculated \cr
   tlast \tab time of last sample with measurable concentration \cr
   clast.obs \tab observed concentration at tlast \cr
   aucall \tab auc calculated over all observations, including values below LOQ (which are set to 0) \cr
   auclast \tab auc calculated using all observations up to and including the last measurable concentration (clast.obs at tlast) \cr
   aumcall \tab aumc calculated over all observations, including values below LOQ (which are set to 0) \cr
   aumclast \tab aumc calculated using all observations up to and including the last measurable concentration (clast.obs at tlast) \cr
   tau \tab the dosing interval (if specified) \cr
   calc.tau \tab flags if AUCtau could be calculated \cr
   auctau \tab auc calculated over the dosing interval, only calculated if tau is specified \cr
   aumctau \tab aumc calculated over the dosing interval, only calculated if tau is specified \cr
   teval \tab user selected AUC interval starting at t=0 (if specified) \cr
   calc.teval \tab flags if AUCteval could be calculated \cr
   aucxx \tab auc calculated from t=0 up to/including teval, only calculated if teval is specified (xx is substituted by teval) \cr
   calc.part \tab flags if AUCpart could be calculated \cr
   tstart \tab start time of partial AUC (if specified) \cr
   tend \tab end time of partial AUC (if specified) \cr
   aucx_y \tab partial auc from time=x up to/including time=y, where x>0, only calculated if tstart and tend are specified \cr
   c0 \tab back-extrapolated concentration at t=0 for IV bolus administration \cr
   area.back.extr \tab area back-extrapolated to 0 \cr
}
}
\description{
Calculates PK parameters for which half-life is not needed in the calculation for each PK curve defined using \code{by}.
}
\examples{
\donttest{
example(correct.conc)
par <- x \%>\% calc.par(by = 'subject')
par \%>\% head
}
}
